/*
 * frefs - forward reference preprocessor for ss and mm
 */

#include <stdio.h>
#include <signal.h>

char column[512+1];
int p;
int l = 0;
int entry[1+6];
char format[1+6];
char *temp_fn, *mktemp();

main(argc, argv)
int argc;
char *argv[];
{
	int f, p;
	extern int intr();
	int frefs(), fonts();
	static int (*pass[2])() = {frefs, fonts};
	FILE *fp, *temp_fp;

	if (signal(SIGHUP,  SIG_IGN) == 0)
		signal(SIGHUP,  intr);
	if (signal(SIGINTR, SIG_IGN) == 0)
		signal(SIGINTR, intr);
	if (signal(SIGQUIT, SIG_IGN) == 0)
		signal(SIGQUIT, intr);
	signal(SIGTERM, intr);
	signal(SIGNOSPC, intr);

	printf(".af 1) 1\n");
	printf(".af A) A\n");
	printf(".af a) a\n");
	printf(".af I) I\n");
	printf(".af i) i\n");

	argc--;
	if (argc == 0) {
		if (isatty(fileno(stdin))) {
			fprintf(stderr, "frefs:  no files specified\n");
			exit(1);
		} else {
			temp_fn = mktemp("/tmp/frefs.XXXXXX");
			temp_fp = fopen(temp_fn, "w");
			if (temp_fp == NULL) {
				fprintf(stderr, "frefs:  no room on /tmp; try again later.\n");
				exit(1);
			}
			frefs(stdin, temp_fp, "stdin");
			freopen(temp_fn, "r", temp_fp);
			fonts(temp_fp, stdin, "stdin");
			unlink(temp_fn);
		}
	} else {
		for (p=0; p<=1; p++) {
			for (f=1; f<=argc; f++) {
				fp = fopen(argv[f], "r");
				if (fp == NULL) {
					fprintf(stderr, "frefs:  cannot open %s\n", argv[f]);
					exit(1);
				}
				(*pass[p])(fp, stdin, argv[f]);
				fclose(fp);
			}
		}
	}

	printf(".rm 1)\n");
	printf(".rm A)\n");
	printf(".rm a)\n");
	printf(".rm I)\n");
	printf(".rm i)\n");
}

frefs(fp, temp_fp, name)
FILE *fp, *temp_fp;
char *name;
{
	static char word[80+1];
	static char delm[20+1];
	static char o_format[1+6+1] = " IA1ai1";
	static int appendix = 0;
	static int figure;
	static int h = 0;
	static int o = 0;
	static int section[1+5] = {0, 0, 0, 0, 0, 0};
	static int sec_hdng;
	int i;
	int w;
	char *fgets();

	while (fgets(column, 512, fp) != NULL) {
		p = 3;
		if (column[0] == '.') {
			switch (column[1]) {
			case 'a':
				if (column[2] == 'l') {
					get(word, &w);
					if (w == 0) {
						word[0] = '1';
						word[1] = '\0';
					}
					list(word[0]);
				} else if (column[2] == 'p') {
					sec_hdng = 0;
					appendix++;
					h = 0;
					for (i=0; i<=5; i++)
						section[i] = 0;
				}
				break;
			case 'b':
				if (column[2] == 'l') {
					list('1');
				}
				break;
			case 'd':
				if (column[2] == 'l') {
					list('1');
				}
				break;
			case 'f':
				if (column[2] == 'g') {
					figure = find("Figure");
				}
				break;
			case 'g':
				if (column[2] == 'f') {
					get(word, &w);
					figure = find(word);
				}
				break;
			case 'h':
				if (column[2] == 'd') {
					sec_hdng = 1;
					get(word, &w);
					if (w == 0) {
						word[0] = '+';
						word[1] = '0';
						word[2] = '\0';
					}
					if (word[0] == '+')
						h += word[1] - '0';
					else if (word[0] == '-')
						h -= word[1] - '0';
					else
						h = word[0] - '0';
					if (h < 0)
						h = 0;
					else if (h > 5)
						h = 5;
					section[h]++;
					for (i=h+1; i<=5; i++)
						section[i] = 0;
				}
				break;
			case 'i':
				if (column[2] == 'l') {
					list('1');
				}
				break;
			case 'l':
				if (column[2] == 'e') {
					entry[l]++;
				} else if (column[2] == 'x') {
					if (o > 0)
						o--;
				        if (l > 0)
						l--;

				}
				break;
			case 'o':
				if (column[2] == 'l') {
					o++;
					list(o_format[o]);
				}
				break;
			case 'r':
				if (column[2] == 'l') {
					list('1');
				}
				break;
			case 's':
				if (column[2] == 'f') {
					get(word, &w);
					printf(".ds %s %d\n", word, figure);
				} else if (column[2] == 'h') {
					get(word, &w);
					get(delm, &w);
					if (sec_hdng) {
						printf(".ds %s ", word);
						if (h >= 1)
							printf("%d", section[1]);
						if (h==1 && w>0)
							printf("%s", delm);
						for (i=2; i<=h; i++)
							printf(".%d", section[i]);
						printf("\n");
					} else {
						printf(".nr A) %d\n", appendix);
						printf(".ds %s \\n(A)\n", word);
					}
				} else if (column[2] == 'l') {
					get(word, &w);
					get(delm, &w);
					if (w == 0) {
						printf(".nr %c) %d\n", format[l], entry[l]);
						printf(".ds %s \\n(%c)\n", word, format[l]);
					} else {
						if (delm[0] == '"') {
							for (i=0; i<w; i++) {
								delm[i] = delm[i+1];
							}
							w--;
							if (delm[w-1] == '"') {
								delm[--w] = '\0';
							}
						}
						printf(".nr %c) %d\n", format[1], entry[1]);
						printf(".ds %s \\n(%c)\n", word, format[1]);
						for (i=2; i<=l; i++) {
							printf(".nr %c) %d\n", format[i], entry[i]);
							printf(".as %s \"%s\\n(%c)\n", word, delm, format[i]);
						}
					}
				}
				break;
			case 'v':
				if (column[2] == 'l') {
					list('1');
				}
				break;
			}
		}
		if (temp_fp != stdin)
			fprintf(temp_fp, "%s", column);
	}
}

get(word, w)
char word[];
int *w;
{
	char last;

	for ( ; column[p]==' '; p++) ;
	last = ' ';
	*w = 0;
	while (column[p]!='\n' && (column[p]!=' ' || last=='\\') && *w<40) {
		word[*w] = last = column[p];
		p++;
		(*w)++;
	}
	word[*w] = '\0';
}

int find(word)
char word[];
{
	static char string[1+26][40+1];
	static int number[1+26];
	static int f = 0;
	int i;

	strcpy(string[f], word);
	for (i=0; strcmp(string[i], word)!=0; i++) ;
	if (i == f && f < 26) {
		number[f] = 0;
		f++;
	}
	number[i]++;
	return(number[i]);
}

list(frmt)
char frmt;
{
	if (l <= 5)
		l++;
	entry[l] = 0;
	format[l] = frmt;
}

fonts(fp, temp_fp, name)
FILE *fp, *temp_fp;
char *name;
{
	static int roman  = '\0';
	static int bold   = '\0';
	static int italic = '\0';
	static int font   = '\0';
	static int escape = '\\';
	int line_no = 1;
	int c;

	newline(&c, fp, &bold, &italic);
	for (;;) {
		while (c == '\n') {
			if (font != roman) {
				fprintf(stderr, "frefs:  line %d of file %s ended in non-roman font\n", line_no, name);
				font = roman;
			}
			putchar(c);
			line_no++;
			newline(&c, fp, &bold, &italic);
		}
		if (c == escape) {
			c = getc(fp); 
			if (c!=bold && c!=italic) {
				if (c=='\n')
					line_no++;
				putchar(escape);
			}
			putchar(c);
		} else if (c == bold) {
			if (font == bold) {
				printf("\\fR");
				font = roman;
			} else {
				printf("\\fB");
				font = bold;
			}
		} else if (c == italic) {
			if (font == italic) {
				printf("\\fR");
				font = roman;
			} else {
				printf("\\fI");
				font = italic;
			}
		} else if (c == EOF) {
			return;
		} else {
			putchar(c);
		}
		c = getc(fp);
	}
}

newline(c, fp, bold, italic)
int *c, *bold, *italic;
FILE *fp;
{
	*c = getc(fp);
	if (*c == '.') {
		putchar(*c);
		*c = getc(fp);
		if (*c == 'f') {
			putchar(*c);
			*c = getc(fp);
			if (*c == 'o') {
				do_fo(c, fp, bold, italic);
			}
		}
	}
}

do_fo(c, fp, bold, italic)
int *c, *bold, *italic;
FILE *fp;
{
	putchar(*c);
	*c = getc(fp);
	while (*c==' ' || *c=='\t' || *c=='\\') {
		putchar(*c);
		*c = getc(fp);
	}
	*bold = *italic = '\0';
	if (*c != '\n') {
		*bold = *c;
		putchar(*c);
		*c = getc(fp);
		while (*c==' ' || *c=='\t' || *c=='\\') {
			putchar(*c);
			*c = getc(fp);
		}
		if (*c != '\n') {
			*italic = *c;
			putchar(*c);
			*c = getc(fp);
			while (*c != '\n') {
				putchar(*c);
				*c = getc(fp);
			}
		}
	}
}

intr(sig)
int sig;
{
	if (sig == SIGNOSPC) {
		fprintf(stderr, "frefs: disk full error, try again\n");
	}
	unlink(temp_fn);
	_exit(1);
}
