/*
 * fonts - easy font changing preprocessor for nroff, ss, and mm
 * options:
 *       -fbi  make b and i the initial font change characters
 *       -x    remove font change sequence, without replacing it
 */

#include <stdio.h>

#define SHIFT {argc--; argv++; arg = *argv;}

int roman  = '\0';
int bold   = '\0';
int italic = '\0';

main(argc, argv)
int argc;
char *argv[];
{
	int xflg = 0;
	char *arg;
	FILE *fp;

	SHIFT;
	while (argc > 0 && arg[0] == '-') {
		switch (arg[1]) {
		case 'f':
                        bold = arg[2];
                        if (bold != '\0') {
                                italic = arg[3];
                        }
			break;
		case 'x':
		        xflg++;
			break;
		default:
			fprintf(stderr, "fonts: invalid %s option\n", *argv);
			exit(1);
		}
		SHIFT;
	}
	if (argc == 0) {
		fonts(stdin, "stdin", xflg);
	} else {
		while (argc > 0) {
			fp = fopen(arg, "r");
			if (fp == NULL) {
				fprintf(stderr, "fonts:  cannot open %s\n", arg);
				exit(1);
			}
			fonts(fp, arg, xflg);
			fclose(fp);
			SHIFT;
		}
	}
}

fonts(fp, name, xflg)
FILE *fp;
char *name;
int xflg;
{
	static int font   = '\0';
	static int escape = '\\';
	int line_no = 1;
	int c;

	newline(&c, fp, &bold, &italic);
	for (;;) {
		while (c == '\n') {
			if (font != roman) {
				fprintf(stderr, "fonts:  line %d of file %s ended in non-roman font\n", line_no, name);
				font = roman;
			}
			putchar(c);
			line_no++;
			newline(&c, fp, &bold, &italic);
		}
		if (c == escape) {
			c = getc(fp); 
			if (c!=bold && c!=italic) {
				if (c=='\n')
					line_no++;
				putchar(escape);
			}
			putchar(c);
		} else if (c == bold) {
			if (font == bold) {
				if (!xflg)
					printf("\\fR");
				font = roman;
			} else {
				if (!xflg)
					printf("\\fB");
				font = bold;
			}
		} else if (c == italic) {
			if (font == italic) {
				if (!xflg)
					printf("\\fR");
				font = roman;
			} else {
				if (!xflg)
					printf("\\fI");
				font = italic;
			}
		} else if (c == EOF) {
			return;
		} else {
			putchar(c);
		}
		c = getc(fp);
	}
}

newline(c, fp, bold, italic)
int *c, *bold, *italic;
FILE *fp;
{
	*c = getc(fp);
	if (*c == '.') {
		putchar(*c);
		*c = getc(fp);
		if (*c == 'f') {
			putchar(*c);
			*c = getc(fp);
			if (*c == 'o') {
				do_fo(c, fp, bold, italic);
			}
		}
	}
}

do_fo(c, fp, bold, italic)
int *c, *bold, *italic;
FILE *fp;
{
	putchar(*c);
	*c = getc(fp);
	while (*c==' ' || *c=='\t' || *c=='\\') {
		putchar(*c);
		*c = getc(fp);
	}
	*bold = *italic = '\0';
	if (*c != '\n') {
		*bold = *c;
		putchar(*c);
		*c = getc(fp);
		while (*c==' ' || *c=='\t' || *c=='\\') {
			putchar(*c);
			*c = getc(fp);
		}
		if (*c != '\n') {
			*italic = *c;
			putchar(*c);
			*c = getc(fp);
			while (*c != '\n') {
				putchar(*c);
				*c = getc(fp);
			}
		}
	}
}
