/*
*  This routine formats a file so it can be punched as 80-byte
*  records.  Output records are formated as follows:
*
*  -------------------------------------------------------------------
*  | 6 char line# | 2 char seq# | 72 bytes of data                   |
*  -------------------------------------------------------------------
*/

#include <stdio.h>
int lineno, lno;
main(argc, argv) char **argv;
{
	FILE *file;

	if (--argc <= 0)
		process(stdin);
	else {
		++argv;
		do {
			if (strcmp(*argv, "-")==0)
				file = stdin;
			else
				if ((file = fopen(*argv, "r"))==NULL) {
					fprintf(stderr, "Cannot open %s\n",
						*argv);
					continue;
				}
			process(file);
			fclose(file);
			++argv;
		} while(--argc);
	}
}


process(file)
FILE *file;
{
	int reclen, bleft;
	static char line[BUFSIZ];
	char card[81], *s;

	lno = 0;
	while((bleft = getline(line, file)) > 0) {
		bleft--;
		s = line;
		lineno++;
                while (bleft>=0) {
			reclen = bleft;
			if (reclen > 72) reclen=72;
			sprintf(card, "%6d%2d", lineno, reclen);
			if (reclen>0) move(s, card+8, reclen);
			card[reclen+8] = 0;
			puts(card);
			s += 72;
			bleft -= 72;
		}
	}
}

/*
*  Get the next line, expanding all tab characters not contained within
*  quotes to an appropriate number of blanks.  Return the length.
*  It also expands a few special 1 character things (like braces)
*  into their two character equivalents.
*/
getline(line, file) char *line;  FILE *file;
{
	register c;
	register char *l;
	int len, i, mode;

	l = line;
	len  = 0;
	mode = 1;
	while ((c=getc(file)) != EOF) {
		len++;
		if (len > BUFSIZ-1) {
			fprintf(stderr, "Max line length exceeded.\n");
			exit(1);
		}
		if (mode == 1)
			if (c == '"' || c == '\'') mode = 0;
		else
			if (c == '"' || c == '\'') mode = 1;
		if (c == '\t' && mode) {
			i = len + (8-(len-1)%8) - 1;
			while (len < i) {
				len++;
				*l++ = ' ';
			}
			*l++ = ' ';
		}
		else {
			switch(c) {
				case '[':
					*l++ = '(';
					*l++ = '|';
					len++;
					break;
				case ']':
					*l++ = '|';
					*l++ = ')';
					len++;
					break;
				case '{':
					*l++ = '(';
					*l++ = '<';
					len++;
					break;
				case '}':
					*l++ = '>';
					*l++ = ')';
					len++;
					break;
				case '^':
					*l++ = '\\';
					*l++ = '~';
					len++;
					break;
				default:
					*l++ = c;
					break;
			}
			if (c == '\n' || c == '\f' || c == '\r') break;
		}
	}
	if (len == 0)
		return(-1); /* hit end of file */
	*l = '\0';
	return(len);
}
