#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/inode.h"
#include "../h/reg.h"
#include "../h/text.h"
#include "../h/signal.h"
#include "../h/370.h"
#include "../h/bitmap.h"

/*
 * Send the specified signal to
 * all processes with 'pgrp' as
 * process group.
 * Called by tty.c for quits and
 * interrupts.
 */
signal(pgrp, sig)
register pgrp;
{
	register struct proc *p;

	if(pgrp == 0)
		return;
	for(p = &proc[0]; p < &proc[NPROC]; p++)
		if(p->p_pgrp == pgrp)
			psignal(p, sig);
}

/*
 * Send the specified signal to
 * the specified process.
 */
psignal(p, sig)
register struct proc *p;
register sig;
{

	if(sig < 0 || sig > NSIG)
		return;
	if(sig) {
		bset(p->p_sig, sig);
		p->p_issig = 1;
	}
	if(p->p_pri > PUSER)
		p->p_pri = PUSER;
	if(p->p_stat == SSLEEP && p->p_pri > PZERO)
		setrun(p);
}

/*
 * Returns true if the current
 * process has a signal to process.
 * This is asked at least once
 * each time a process enters the
 * system.
 * A signal does not do anything
 * directly to a process; it sets
 * a flag that asks the process to
 * do something to itself.
 */
issig()
{
        register n;
        register struct proc *p;
 
        p = u.u_procp;
        while(n = fsig(p->p_sig)) {
		bclr(p->p_sig, n);
                if((p->p_flag&STRC) && btst(u.u_sigtr, n)) {
			u.u_ps.ps_sig = n;
                        stop();
                        n = u.u_ps.ps_sig;
                }
                if(n && (u.u_signal[n]&1) == 0) {
			bset(u.u_sig, n);
			u.u_issig = 1;
		}
        }
	p->p_issig = 0;
	return(fsig(u.u_sig));
}
 
/*
 * Enter the tracing STOP state.
 */
stop()
{
        register struct proc *pp, *cp;
 
loop:
        cp = u.u_procp;
        if(cp->p_ppid != 1)
        for (pp = &proc[0]; pp < &proc[NPROC]; pp++)
                if (pp->p_pid == cp->p_ppid) {
                        wakeup((caddr_t)pp);
                        cp->p_stat = SSTOP;
                        swtch();
                        if ((cp->p_flag&STRC)==0 || procxmt())
                                return;
                        goto loop;
                }
        exit(u.u_ps.ps_sig);
}
 
/*
 * Perform the action specified by
 * the current signal.
 * The usual sequence is:
 *      if(issig())
 *              psig();
 */
psig()
{
        int n, p;
 
	while(n = fsig(u.u_sig)) {
		bclr(u.u_sig, n);
		if((p = u.u_signal[n]) == 0) {
			if(sigact[n] & CORE) {
				u.u_arg[0] = n;
				if(core()) n |= 0200;
			}
			exit(n);
		}
                u.u_error = 0;
		if((sigact[n] & NORESET) == 0)
			u.u_signal[n] = 0;
		sendsig((caddr_t)p, n);
        }
	u.u_issig = 0;
}

/*
 * Find a signal in the bit map
 */
fsig(map)
register char *map;
{
	register i;

	for(i = 1; i <= NSIG; i++)
		if(btst(map, i))
			return(i);
	return(0);
}

/*
 * Create a core image on the file "core"
 * If you are looking for protection glitches,
 * there are probably a wealth of them here
 * when this occurs to a suid command.
 *
 * It writes USIZE block of the
 * user.h area followed by the entire
 * data+stack segments.
 */
core()
{
	register struct inode *ip;
	extern schar();

	u.u_error = 0;
	u.u_dirp = "core";
	ip = namei(schar, 0);
	if(ip == NULL) {
		return(0);
	}
	if(!access(ip, IWRITE) &&
	   (ip->i_mode&IFMT) == IFREG &&
	   u.u_uid == u.u_ruid) {
		itrunc(ip);
		u.u_offset = 0;
		u.u_base = (caddr_t)&u;
		u.u_count = ctob(USIZE);
		u.u_segflg = 1;
		writei(ip);
		u.u_base = (char *)ctob(stoc(ctos(u.u_tseg.u_size)));
		u.u_count = ctob(u.u_dseg.u_size);
		u.u_segflg = 0;
		writei(ip);
		u.u_count = ctob(u.u_sseg.u_size);
		u.u_base = (char *)((-u.u_count) & ADDRMASK);
		writei(ip);
	}
	iput(ip);
	return(u.u_error==0);
}

/*
 * grow the stack to include the sp
 * true return if successful.
 */
grow(sp)
int sp;
{
        register a;
 
        a = (-ctob(u.u_sseg.u_size)) & ADDRMASK;
        sp &= ADDRMASK;
        if(sp >= a)
		return(0);
        a = btoc(a - sp);
        if(a + u.u_tseg.u_size + u.u_dseg.u_size + u.u_sseg.u_size > maxmem)
		return(0);
        if(a >= pagecnt)
		return(0);
        grow1(a, &u.u_sseg);
        mkstab(&u, 0);
        return(1);
}
