#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/proc.h"
#include "../h/reg.h"
#include "../h/370.h"

/*
 * Machine-dependent startup code
 * Initialize memory management, I/O, and machine-check handling
 */
startup()
{
	mckinit();
	paginit();
	if(vm & SEPP)
		d_vmai(&vmai);
	ioinit();
}

/*
 * Get the current time and set up for first TOD comparator interrupt
 */
clkstart()
{
	tod_t tod, a_stck();

	tod = a_stck();
	a_sckc(tod + (1000000L<<12));  /* tod + 1 sec */
	time = ctime(tod);
}

/*
 * Let a process handle a signal by simulating an interrupt
 */
sendsig(p, signo)
caddr_t p;
{
	register n;

	n = u.u_ar0[R13]- 12;
	grow(n);
	suword((caddr_t)n+8, u.u_ar0[R15]);
	suword((caddr_t)n+4, u.u_ar0[RPC]);
	suword((caddr_t)n, u.u_ar0[RPS]);
	u.u_ar0[R13] = n;
	u.u_ar0[RPC] = (int)p & PCMASK;
	u.u_ar0[R15] = (int)p | (signo << 24);
}

/*
 * Return from signal.
 * Pops psw and r15 from user stack,
 * so process can restore last register
 * and branch at the same time.
 */
rsig()
{
        register n;

        n = u.u_ar0[R13];
        u.u_ar0[RPS] &= ~PSMASK;
        u.u_ar0[RPS] |= (fuword((caddr_t)n) & PSMASK);
        u.u_ar0[RPC] = fuword((caddr_t)n+4) & PCMASK;
        u.u_ar0[R15] = fuword((caddr_t)n+8);
        u.u_ar0[R13] += 12;
}
