/*
 * VMCF parameter block
 * Double-word aligned
 */
struct vmcparm {
        char    p_flg1;         /* flag byte */
        char    p_flg2;         /* unused */
        short   p_func;         /* function code */
        int     p_mid;          /* message id */
        char    p_user[8];      /* user id */
        caddr_t p_vada;         /* main buffer addr */
        int     p_lena;         /* main buffer length */
        caddr_t p_vadb;         /* reply buffer addr */
        int     p_lenb;         /* reply buffer length */
        char    p_use[8];       /* user info */
} vmcparm;

/* bits in p_flg1 */
#define P_AUTS  0x80            /* authorize specific user */
#define P_PRTY  0x40            /* authorize priority messages */
#define P_SMSG  0x20            /* authorize special messages */

/* p_func */
#define P_AUTH  0               /* authorize */
#define P_UAUT  1               /* unauthorize */
#define P_SEND  2               /* send */
#define P_SENR  3               /* send/receive */
#define P_SENX  4               /* sendx */
#define P_RECV  5               /* receive */
#define P_CANC  6               /* cancel */
#define P_REPL  7               /* reply */
#define P_QUIE  8               /* quiesce */
#define P_RESM  9               /* resume */
#define P_IDEN  10              /* identify */
#define P_RJCT  11              /* reject */

/*
 * VMCF Message Header
 * double-word aligned
 */
#define SENXLEN 136             /* sendx message length */
struct vmcmhdr {
        char    m_stat;         /* status */
        char    m_eflg;         /* data transfer status */
        short   m_func;         /* function code */
        int     m_mid;          /* message id */
        char    m_user[8];      /* user id */
        caddr_t m_vada;         /* buffer addr */
        int     m_lena;         /* buffer length */
        caddr_t m_vadb;         /* buffer addr */
        int     m_lenb;         /* buffer length */
        char    m_use[8];       /* user info */
        char    m_buf[SENXLEN]; /* sendx buffer */
} vmcmhdr;

/* bits in m_stat */
#define M_RESP  0x80            /* response or final interrupt */
#define M_RJCT  0x40            /* rejected */
#define M_PRTY  0x20            /* priority interrupt */
