#include "../h/conf.h"
#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/io.h"
 
extern char atetab[ ];
 
/* Driver for UNIX/470 virtual punch */
 
#define PUNMAX     1             /* number of punches                */
#define BUFFSIZE   80            /* buffer size for punch            */
#define MAXCHAIN   20            /* number of ccw's for channel prog */
#define WRITE      0x01          /* write ccw code                   */
#define PUPRI   PUSER
 
/* states of a punch */
 
#define FREE     0
#define OPEN     1
#define DONE     2
#define ERROR    3
 
/* Punch information */
 
struct vmpunch  {
	ccw_t pun_ccws[MAXCHAIN];
        char *pun_bfp;            /* pointer to next char in buffer   */
        char pun_buf[MAXCHAIN][BUFFSIZE];   /* punch buffers          */
        int  pun_state;           /* current state of punch           */
        int  pun_count;           /* current count of chars in buffer */
        int  pun_addr;            /* device address                   */
	int  pun_bs;              /* working buffer number            */
	int  pun_avail;           /* availablity of punch             */
}  pun_info[PUNMAX];

 
/* Punch OPEN routine */
/* ARGSUSED */
punopen(dev,flag)
int dev,flag;
{
	int ct;
        struct vmpunch *pun;
        char cpbuf[20];
	char *sprintf();

        pun = &pun_info[minor(dev)];
        if (pun->pun_avail != FREE)  {
                u.u_error = EIO;        /* punch not available */
                return;
        }
        pun->pun_avail = OPEN;
        pun->pun_state = OPEN;
	for(ct=0; ct<MAXCHAIN; ct++) {
		pun->pun_ccws[ct].cc_dblw = 0;
	        pun->pun_ccws[ct].cc_cmd = WRITE;
	        pun->pun_ccws[ct].cc_addr = (int)(pun->pun_buf[ct]);
	        pun->pun_ccws[ct].cc_count = BUFFSIZE;
	}
        pun->pun_addr = cdevsw[major(dev)].d_addrs[minor(dev)];
        pun->pun_count = 0;                /* initialize character count*/
	pun->pun_bs = 0;                   /* initialize buffer count   */
        pun->pun_bfp = pun->pun_buf[0];    /* initialize buffer pointer */
        cpcmd(sprintf(cpbuf, "SP %3x CL A", pun->pun_addr));
}

/*
 * Close punch routine
 * this routine flushes the punch buffer and closes the punch
 */
punclose(dev)
int dev;
{
        struct vmpunch *pun;

        pun = &pun_info[minor(dev)];
        if (pun->pun_count)  {    /* if leftovers in punch buffer, */
                                  /* flush to punch                */
                while (pun->pun_count < BUFFSIZE)   {
                       *pun->pun_bfp++ = atetab[' '];
                       pun->pun_count++;
                }
		if(pun->pun_bs)
			pun->pun_ccws[pun->pun_bs - 1].cc_cc = 1;
        }
	if(pun->pun_bfp != pun->pun_buf[0])
		punsio(pun);
        pun->pun_avail = FREE;
        pun->pun_state = FREE;
        cpclose(pun->pun_addr);
}
 
/* write to the punch */
 
punwrite(dev)
int dev;
{
         int ct;
         struct vmpunch *pun;

         pun = &pun_info[minor(dev)];
         for (;;)  {
                if (punfill(dev)) return(0);/* error, or user buffer    */
                                            /* empty before punch       */
                                            /* buffer filled.           */
		if(pun->pun_bs)
			pun->pun_ccws[pun->pun_bs - 1].cc_cc = 1;
		if(pun->pun_bs == MAXCHAIN-1) {
			pun->pun_bs = -1;
			punsio(pun);
			for(ct=0; ct<MAXCHAIN; ct++)
				pun->pun_ccws[ct].cc_cc = 0;
			pun->pun_bfp = pun->pun_buf[0];
		}
		pun->pun_count = 0;
		pun->pun_bs++;
	}
	/*NOTREACHED*/
}
 

 
/* start IO for the Punch */
 
punsio(pun)
struct vmpunch *pun;
{
        int punintr();

        sio(pun->pun_addr, &pun->pun_ccws[0], punintr, (int)pun);
        while(pun->pun_state == OPEN)
		sleep((caddr_t)pun, PUPRI);
        if(pun->pun_state == ERROR)
                u.u_error = EIO;
        pun->pun_state = OPEN;
}
 
 
/* interrupt handler for the punch driver */
/* ARGSUSED */
punintr(pun, csw, sense)
struct vmpunch *pun;
csw_t *csw;
char *sense;
{
        if(csw->cs_uc || csw->cs_ue) {
                pun->pun_state = ERROR;
        } else if(csw->cs_de) {
                pun->pun_state = DONE;
        }
        if(pun->pun_state != OPEN)
                wakeup((caddr_t)pun);
}

punfill(dev)
int dev;
{
	int c;
	struct vmpunch *pun;

	pun = &pun_info[minor(dev)];
	while( pun->pun_count < BUFFSIZE ) {
		if((c = cpass()) == -1)
			return(-1);
		pun->pun_count++;
		*pun->pun_bfp++ = c;
	}
	return(0);
}
