#include "../h/param.h"
#include "../h/systm.h"
#include "../h/buf.h"
#include "../h/tty.h"
#include "../h/conf.h"
#include "../h/proc.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/text.h"
#include "../h/file.h"
#include "../h/inode.h"

typedef int func();

/*
 * the block device table, bdevsw
 */

func   dskopen, dskclose, dskstrat;
func   nullsys, nullsys, viostrat;

struct buf dsk110tab;
struct buf dsk220tab;
struct buf dsk330tab;
struct buf dsk440tab;
struct buf dsk550tab;
struct buf dsk660tab;
struct buf dsk880tab;
struct buf dsk770tab;
struct buf dskdd0tab;
struct buf vio0tab;

struct bdevsw bdevsw[] = {
        dskopen, dskclose, dskstrat, &dsk110tab, 0x110, 
        dskopen, dskclose, dskstrat, &dsk220tab, 0x220, 
        dskopen, dskclose, dskstrat, &dsk330tab, 0x330, 
        dskopen, dskclose, dskstrat, &dsk440tab, 0x440, 
        dskopen, dskclose, dskstrat, &dsk550tab, 0x550, 
        dskopen, dskclose, dskstrat, &dsk660tab, 0x660, 
        dskopen, dskclose, dskstrat, &dsk880tab, 0x880,
        dskopen, dskclose, dskstrat, &dsk770tab, 0x770, 
        dskopen, dskclose, dskstrat, &dskdd0tab, 0xDD0, 
        nullsys, nullsys, viostrat, &vio0tab, 0x000, 
        0
};

/*
 * the character device table, cdevsw
 */

func   conopen, conclose, conread, conwrite, conioctl, nulldev;
func   trmopen, trmclose, trmread, trmwrite, trmioctl, nulldev;
func   tubopen, tubclose, tubread, tubwrite, tubioctl, nulldev;
func   rwdopen, rwdclose, rwdread, rwdwrite, nottty, nulldev;
func   fdopen, fdclose, fdread, fdwrite, fdioctl, nulldev;
func   propen, prclose, nodev, prwrite, prioctl, nulldev;
func   punopen, punclose, nodev, punwrite, nottty, nulldev;
func   cropen, crclose, crread, nodev, nottty, nulldev;
func   tapopen, tapclose, tapread, tapwrite, tapioctl, nulldev;
func   fsopen, fsclose, fsread, fswrite, fsioctl, nulldev;
func   nulldev, nulldev, mmread, mmwrite, nottty, nulldev;
func   syopen, nulldev, syread, sywrite, sysioctl, nulldev;
func   vcfopen, vcfclose, vcfread,  vcfwrite, nottty, nulldev;
func   nulldev, nulldev, tagread, nodev, nottty, nulldev;
func   smsgopen, smsgclose, smsgread, nodev, smsgctl, nulldev;
func   vmcopen, vmcclose, vmcread, vmcwrite, vmcioctl, nulldev;
func   ldsopen, ldsclose, ldsread, ldswrite, ldsioctl, nulldev;

int     conaddr[] = {0x009, };
int     trmaddr[] = {0x030, 0x031, };
int     tubaddr[] = {0x400, 0x401, 0x402, 0x403, 0x404, 0x405, 0x406, 0x407, 0x408, 0x409, 0x40A, 0x40B, 0x40C, 0x40D, 0x40E, 0x40F, };
int     rdskaddr[] = {0x110, 0x220, 0x330, 0x440, 0x550, 0x660, 0x770, 0xDD0, };
int     fdskaddr[] = {0x110, 0x220, 0x330, 0x440, 0x550, 0x660, 0x770, 0xDD0, };
int     prtaddr[] = {0x00E, };
int     punaddr[] = {0x00D, };
int     rdraddr[] = {0x00C, };
int     tapaddr[] = {0x181, 0x182, 0x183, 0x184, };

struct cdevsw cdevsw[] = {
        tubopen, tubclose, tubread, tubwrite, tubioctl, nulldev, tubaddr, 0, 
        fsopen, fsclose, fsread, fswrite, fsioctl, nulldev, 0, 0, 
        trmopen, trmclose, trmread, trmwrite, trmioctl, nulldev, trmaddr, 0, 
        rwdopen, rwdclose, rwdread, rwdwrite, nottty, nulldev, rdskaddr, 0, 
        fdopen, fdclose, fdread, fdwrite, fdioctl, nulldev, fdskaddr, 0, 
        conopen, conclose, conread, conwrite, conioctl, nulldev, conaddr, 0, 
        cropen, crclose, crread, nodev, nottty, nulldev, rdraddr, 0, 
        punopen, punclose, nodev, punwrite, nottty, nulldev, punaddr, 0, 
        propen, prclose, nodev, prwrite, prioctl, nulldev, prtaddr, 0, 
        vmcopen, vmcclose, vmcread, vmcwrite, vmcioctl, nulldev, 0, 0, 
        ldsopen, ldsclose, ldsread, ldswrite, ldsioctl, nulldev, 0, 0, 
        vcfopen, vcfclose, vcfread,  vcfwrite, nottty, nulldev, 0, 0, 
        smsgopen, smsgclose, smsgread, nodev, smsgctl, nulldev, 0, 0, 
        tapopen, tapclose, tapread, tapwrite, tapioctl, nulldev, tapaddr, 0, 
        nulldev, nulldev, mmread, mmwrite, nottty, nulldev, 0, 0, 
        nulldev, nulldev, tagread, nodev, nottty, nulldev, 0, 0, 
        syopen, nulldev, syread, sywrite, sysioctl, nulldev, 0, 0, 
        0
};

int     ttyopen(), ttyclose(), ttread(), ttyinput(), ttstart();
char    *ttwrite();
struct  linesw linesw[] = {
        ttyopen, nulldev, ttread, ttwrite, nodev, ttyinput, ttstart, 
        0
};

dev_t   rootdev = makedev(1, 0);
dev_t   pipedev = makedev(8, 0);
dev_t   dumpdev = makedev(7, 0);

int     nldisp = 1;

struct  buf     buf[NBUF];
struct  buf     bfreelist;
struct  proc    proc[NPROC];
struct  inode   inode[NINODE];
struct  file    file[NFILE];
struct  text    text[NTEXT];
int     mpxchan();
int     (*ldmpx)() = mpxchan;
