/ signal system call and interrupt entry
nsig = 33
einval = 22
	entry	signal
signal:
	using	.,r15
	s	sp,=f'4'	/ save r2
	st	r2,0(,sp)
	l	r2,=a(.bss)	/ get bss base
	using	.bss,r2
        l       r1,4(,sp)     	/ signal number
        la      r0,einval      	/ error number
        cl      r1,=a(nsig)    	/ in range?
        bh      sigerr	/ no, error
        sll     r1,2   	/ times 4 bytes
        la      r1,sigtab(r1)  	/ get table addr
        mvc     sigsave(4),0(r1)      	/ save old value
        mvc     0(4,r1),8(sp) 	/ save sig info
        clc     8(4,sp),=f'1'	/ zero or one?
        bh      1f	 	/ no, branch
	la	r1,4(,sp)	/ use args as given
        svc     s_signal
        bz      2f
        b       sigerr
1:	mvc     signum(4),4(sp)       	/ save sig num
	mvc	sigaddr(4),=a(sigent)	/ set entry address
        la      r1,signum
        svc     s_signal
        bnz     sigerr
2:      lr      r1,r0
        n       r1,=f'1'        / special old value?
        bnz     3f              / yes, return it
        l       r0,sigsave      / pass back old value
3:      l       r2,0(,sp)       / restore r2
	la	sp,4(,sp)
        br      r14	/ return
sigerr: l       r15,=v(_cerror)
	l	r2,0(,sp)	/ restore r2
	la	sp,4(,sp)
        br      r15
	drop
/ entry for signal interrupt
sigent:
	using	.,r15
	s	sp,=f'20'
        stm     r14,r1,4(sp)
        lr      r1,r15	/ get signal number
        srl     r1,24
	st	r1,0(,sp)	/ pass as arg
        sll     r1,2
	a	r1,=a(sigtab)
	l	r15,0(,r1)
        drop    r15
        balr    r14,r15
        lm      r14,r1,4(sp)
        la      sp,20(,r13)
        svc     s_rsig
.bss
signum:	ds	f
sigaddr: ds	f
sigsave: ds	f
sigtab:	ds	(nsig+1)f
