/*
 * definitions file for C preprocessor
 */

#define INCLDIR "/usr/include"

#define MAXIDENT 256

#define MAXIF 10
#define MAXLINE 2000
#define MAXNARGS 20
#define LOOPMAX 300
#define MAXDIRS 15

#define DEFINE 1
#define UNDEF 2
#define INCLUDE 3
#define IFDEF 4
#define IFNDEF 5
#define IF 6
#define ENDIF 7
#define ELSE 8
#define LINE 9

#define ON 1
#define OFF 0

#define ALPH(c) (isalpha(c) || c== '_')
#define ALNUM(c) (isalnum(c) || c== '_')

#define PBFSIZ 10000
#define MAXINCL 10

int incl;
char homedir[200];
char pbuf[PBFSIZ];
char *bufftop;
FILE *fp[MAXINCL];
FILE *in;

#define getch()         ((bufftop==pbuf)? (getc(in)): (*--bufftop))
#define strdup(s)       (strcpy(malloc(strlen(s)+1), s))
