#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sgtty.h>

/*
 * Tape guarding daemon.
 */

#define TAPEKILL 4
#define SLEEPSEC 5
#define FIVEMIN  (5*60)
#define ENXIO    6
#define EBUSY   16

extern int errno;

int done;
int forslow;
int ownuid;
int owngid;
int silent;

struct dense {
	int ds_den;
	int ds_code;
} dentab[] = {
	800,    0x0cb,
	1600,   0x0c3,
	6250,   0x0d3,
	0,      0
};

struct stat forstat;
struct pwent *getpwnam();
struct pwent *gotpw;

char mtcmd[] = "MSG OPERATOR MOUNT TAPE %s AS %s %s RING %d BPI (AUTOMATIC REQUEST)";
char dtcmd[] = "DETACH %s ";
char outmess[] = "\"%s\" is ready.";

char nodename[40] = "/dev/tape/";
char lockname[40] = "/dev/tape/lock";
char tapeno[8];
char volser[10];
char allup[10];
char owner[10];
char ring[8];
char command[134];
char cmdb[134];
char xxxx[134];


main(argc, argv)
int argc;
char *argv[];
{
	FILE *fdlock;
	char *targ;
	int lastbit();
	int hexden();
	int density;
	int rung;
	int bk;
	int sec;

	signal(TAPEKILL, lastbit);
	/*
	 * Read the goodies passed down from the spool file. They are:
	 *      Tape name
	 *      Owner
	 *      Tape density
	 *      Either "WITH" or "NO" for the ring.
	 *      Either "*" or the command to be run.
	 */
	gets(volser);
	gets(owner);
	fscanf(stdin, "%d\n", &density);
	fscanf(stdin, "%d\n", &silent);
	gets(ring);
	gets(command);
	fclose(stderr);
	fclose(stdout);
	fclose(stdin);
	/*
	 * argv[1] is a pointer to the mount number
	 * (like "/dev/mt181", "/dev/mt182", ...)
	 */
	targ = argv[1];
	strcpy(tapeno, targ+7);
	raise(volser, allup);
	sprintf(cmdb, mtcmd, allup, tapeno, ring, density);
	strcat(nodename, volser);
	bk = stat(targ, &forstat);
	if (bk == -1)
		die("Cannot stat the tape device");
	umask(0);
	bk = mknod(nodename, forstat.st_mode, forstat.st_rdev);
	if (bk == -1)
		die("This tape Volser already in use");
	if (*ring == 'W')
                chmod(nodename, 0600);
	else
                chmod(nodename, 0400);
	/*
	 *  Issue the mount request and open the tape.
	 */
        bk = cpcmd(cmdb);
        if (bk == -1)
                slowdie("Cannot issue mount request");
        bk = open(nodename, 0);
        if (bk == -1) {
                switch(errno) {
                case EBUSY:
			unlink(nodename);
			sprintf(xxxx, "tape device for %s busy.  Errno %d", volser, errno);
			slowdie(xxxx);
                case ENXIO:
			sec = 0;
			while ((bk = open(nodename, 0)) == -1) {
                                sleep(SLEEPSEC);
				sec += SLEEPSEC;
				if (sec >= FIVEMIN) {
					bk = cpcmd(cmdb);
					if (bk == -1)
						slowdie("Cannot issue mount request");
					sec = 0;
				}
			}
                        break;
                default:
                        sprintf(xxxx, "Unexpected device business, errno = %d", errno);
                        slowdie(xxxx);
                        break;
                }
        }
	/*
	 *  The tape is now open.
	 *  Set rewind on open and close, check the density
	 *  and the status of the write ring.
	 */
        forslow = bk;
	bk = ioctl(forslow, TAPMOTION, 060);
	if (bk == -1) {
		sprintf(xxxx, "Cannot reset default rewind states");
		slowdie(xxxx);
	}
	bk = ioctl(forslow, TAPMODE, hexden(density));
        if (bk == -1) {
                sprintf(xxxx, "Cannot set tape mode : errno = %d", errno);
                slowdie(xxxx);
        }
        bk = ioctl(forslow, TAPRING, &rung);
        if (bk == -1) {
                sprintf(xxxx, "Cannot get ring state: errno = %d", errno);
                slowdie(xxxx);
        }
        if (rung == 0 && *ring == 'W') {
                sprintf(xxxx, "Tape %s improperly mounted: no write ring", volser);
                slowdie(xxxx);
        }
	if (rung == 1 && *ring == 'N') {
                sprintf(xxxx, "Tape %s improperly mounted: it is writable", volser);
                slowdie(xxxx);
        }
        close(forslow);
	gotpw = getpwnam(owner);
	ownuid = gotpw->pw_uid;
	owngid = gotpw->pw_gid;
	chown(nodename, ownuid, owngid);

	if (*command != '*') {
		bk = percents(command);
		switch(bk) {
		case 1:
		        sprintf(cmdb, command, nodename);
		        bk = runit(cmdb);
		        break;
		case 0:
			sprintf(cmdb, "%s", command);
                        bk = runit(command);
			break;
		default:
			bk = -1;
			break;
		}
		if (bk == -1)
			slowdie("Cannot run tape command");
		else if (!silent) {
			bk = (bk >> 8) & 15;
			sprintf(xxxx, "Tape: Command '%s' completed, exit code %d", cmdb, bk);
			notify(owner, xxxx, 0);
		}
	}
	else {
		strcat(lockname, tapeno);
		fdlock = fopen(lockname, "w");
		if (fdlock == NULL)
			slowdie("Cannot open tape lockfile");
		chmod(lockname, 0600);
		fprintf(fdlock, "%s\n%s\n%d\n", volser, owner, getpid());
		fclose(fdlock);
		if (!silent) {
                        sprintf(cmdb, outmess, nodename);
                        notify(owner, cmdb, 0);
                }
		/*
		 * Wait for detachment from above
		 */
		while (!done)
		        pause();
		unlink(lockname);
	}
	/*
	 * Either the command has finished or the tape has
	 * been detached (tape -u)
	 */
	sprintf(cmdb, dtcmd, tapeno);
	bk = cpcmd(cmdb);
	if (bk == -1)
		slowdie("Cannot issue detach command");
	bk = unlink(nodename);
	if (bk == -1)
		die("Cannot unlink the tape device");
}

/*
 * Count the occurances of '%s' in a string.
 */
percents(str)
char *str;
{
	int ct = 0;
	while (*str) {
		if (*str == '%') {
			if (*++str == 's') {
				ct++;
				str++;
			}
		}
		else
			str++;
	}
	return(ct);
}

die(c)
char *c;
{
	sprintf(cmdb, "Tape daemon death : %s", c);
	notify(owner, cmdb, 0);
	exit(1);
}

slowdie(c)
char *c;
{
	if (forslow)
		close(forslow);
	unlink(nodename);
	unlink(lockname);
	sprintf(cmdb, "Tape daemon death : %s", c);
	notify(owner, cmdb, 0);
	sprintf(cmdb, dtcmd, tapeno);
	cpcmd(cmdb);
	exit(1);
}

hexden(d)
int d;
{
	int i = 0;
	while (dentab[i].ds_den != d) {
		i++;
		if (dentab[i].ds_den == 0)
			die("Bad density");
	}
	return(dentab[i].ds_code);
}

lastbit()
{
	done = 1;
	return;
}

raise(from, to)
char *from, *to;
{
	while (*from) {
		*to = islower(*from) ? toupper(*from) : *from;
		to++;
		from++;
	}
	*to = 0;
	return;
}

runit(s)
char *s;
{
	int status, pid, w;
	register int (*istat)(), (*qstat)();

	if ((pid = fork()) == 0) {
		setgid(owngid);
		setuid(ownuid);
		execl("/bin/sh", "sh", "-c", s, 0);
		_exit(127);
	}
	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	return(status);
}
