/*
 * Cpmode passes CP commands to CP and displays the resulting output.
 * It uses the VM Release 6 Virtual Console Function driver.
 * Shell commands can be escaped with '!'.
 */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>

char vcf[] = "/dev/vcf0";
int vfd;
char cmdbuf[136];

main()
{
        int c;
        extern errno;
        char *cp;

	/* Open first VCF device not currently in use */
	do {
		vfd = open(vcf, 2);
		vcf[8]++;
	} while(vfd == -1 && errno == EBUSY);

	/* Process input commands */
        cp = cmdbuf;
        while((c = getchar()) > 0) {
                if(c == '\n') {
                        if(cp > cmdbuf) {
                                *cp++ = '\n';
                                *cp++ = 0;
                                if(cmdbuf[0] == '!') {
                                        dosh(cmdbuf+1);
                                } else {
                                        upcase(cmdbuf);
                                        docp(cmdbuf);
                                }
                        } else printf("CP\n");
                        cp = cmdbuf;
                } else *cp++ = c;
        }
}

/*
 * Pass the command to CP and get the output back.
 */
docp(cmd)
char *cmd;
{
	register n;
	char buf[512];

	write(vfd, cmd, strlen(cmd));
	while((n = read(vfd, buf, sizeof buf)) > 0)
		fwrite(buf, n, 1, stdout);
}

/*
 * Pass a command to the shell and wait for it to finish.
 */
dosh(cmd)
char *cmd;
{
        int pid, stat;

        pid = fork();
        if(pid == 0) {
                execl("/bin/sh", "sh", "-c", cmd, 0);
                exit(1);
        }
        while(wait(&stat) != pid);
        printf("!\n");
}

/*
 * Translate command to upper case.
 */
upcase(cp)
char *cp;
{
        for(;*cp;cp++) {
                if(islower(*cp))
                        *cp = toupper(*cp);
        }
}
