/*
 * Catch messages from a VM user (like OPERATOR)
 * and use /etc/wall to brodcast them to all Au users.
 */
#include <stdio.h>
#include <signal.h>

#define TIMEOUT 20      /* assume messages complete after this interval */
static int intr;

main(argc, argv)
int argc;
char **argv;
{
	int fd, c, catch();
	char *vmid;
	FILE *wall, *msgs, *fdopen(), *popen();

	if(argc > 2) {
		fprintf(stderr, "Usage: vmbrod [vmid]\n");
		exit(1);
	}
	if(fork()) exit(0);
	signal(SIGHUP, SIG_IGN);
	signal(SIGINTR, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	if(argc == 2)
		vmid = argv[1];
	else
		vmid = "operator";
	fd = smsgopen(vmid);
	if(fd < 0 || (msgs = fdopen(fd, "r")) == NULL) {
		fprintf(stderr, "vmbrod: Can't open SMSG device for %s.\n", vmid);
		exit(1);
	}
	signal(SIGALRM, catch);
	while((c = getc(msgs)) != EOF) {       /* forever */
		wall = popen("/etc/wall", "w");
		fprintf(wall, "VM message from %s...\n", vmid);
		do {
                        intr = 0;
                        putc(c, wall);
                        while(c != '\n') {
                                c = getc(msgs);
                                putc(c, wall);
                        }
			alarm(TIMEOUT);
			c = getc(msgs);
			alarm(0);
		} while(c != EOF);
		if(intr)
			clearerr(msgs);
		pclose(wall);
	}
}

catch()
{
	signal(SIGALRM, catch);
	intr = 1;
}
