#include        <stdio.h>
#include        <signal.h>
#include	"defs.h"

char    *trapcom[NSIG];
char    trapflg[NSIG];

/* ========	fault handling routines	   ======== */


fault(sig)
register int  sig;
{
	register int  flag;

	signal(sig, fault);
	if (sig == SIGALRM) {
		if (flags & WAITING)
                        done();
	} else {
		flag = (trapcom[sig] != NULL? TRAPSET: SIGSET);
		trapnote |= flag;
		trapflg[sig] |= flag;
	}
}

stdsigs()
{
	ignsig(SIGQUIT);
	getsig(SIGINTR);
        getsig(SIGALRM);
}

ignsig(n)
register int n;
{
	register int  s;

	if ((s = (int)signal(n, SIG_IGN) & 01) == SIG_DFL)
		trapflg[n] |= SIGMOD;
	return(s);
}

getsig(n)
register int n;
{

	if (trapflg[n] & SIGMOD || ignsig(n) == 0) {
		signal(n, fault);
	}
}

oldsigs()
{
	register int  i;
	register char	*t;

	i = NSIG;
	while (i--) {
		t = trapcom[i];
		if (t == 0 || *t) {
			clrsig(i);
		}
		trapflg[i] = 0;
	}
	trapnote = 0;
}

clrsig(i)
register int	i;
{
	if (trapcom[i] != NULL) {
                free(trapcom[i]);
                trapcom[i] = NULL;
	}
	if (trapflg[i] & SIGMOD) {
		signal(i, fault);
		trapflg[i] &= ~SIGMOD;
	}
}

chktrap()
{
	/* check for traps */
	register int  i = NSIG;
	register char	*t;

	trapnote &= ~TRAPSET;
	while (--i) {
		if (trapflg[i] & TRAPSET) {
			trapflg[i] &= ~TRAPSET;
			if (t = trapcom[i]) {
				int  savxit = exitval;

				execexp(t, (FILE *) NULL);
				exitval = savxit;
				exitset();
			}
		}
	}
}
