#include        <stdio.h>

#define MAXFTN          256
#define LNWIDTH         64
#define TWIDTH          55
#define STAR            '*'
#define HYPHEN          '-'
#define FNAME           'f'
#define TIME            't'
#define PERCENT         'p'

struct  f       {
	int     f_hits;
	char    f_name[9];
} ftn[MAXFTN];

char    monout[] = "mon.out";   /* default file */
char    fflg = 0;               /* sort by function name */
char    tflg = 0;               /* include user time */

main(argc, argv)
int     argc;
char    **argv;
{
	struct  f       *fp;    /* ptr within ftn[] */
	struct  f       *eftn;  /* ptr to last entry in ftn[] */
	FILE    *fd;            /* file descriptor */
	char    *fn;            /* filename of input file */
	int     bar;            /* bar width */
	int     i;
	int     maxhits;        /* max number of hits */
	int     tothits;        /* total number of hits */
	int     otherhits;      /* summation of hits in neglible functions */
	int     nftn;           /* number of functions with non-zero hits */
	int     compar();
	int     lnwidth;        /* line width */
	float   usrtime;        /* total user time */

	argc--;
	argv++;
	while (argc && **argv == HYPHEN) {
		while(*(++*argv)) {
		        switch(**argv) {
			case FNAME:
                                fflg++;
                                break;
			case TIME:
                                tflg++;
				break;
			}
		}
                argc--;
                argv++;
	}

	fn = (argc)? *argv: monout;
        if ((fd = fopen(fn, "r")) == NULL) {
                fprintf(stderr, "%s: Unable to open\n", fn);
                exit(1);
        }

	tothits = maxhits = 0;
	fscanf(fd, "%f", &usrtime);
	fp = ftn;
	while (fscanf(fd, "%s %*x %d", fp->f_name, &fp->f_hits) != EOF) {
		if (fp->f_hits != 0) {
			tothits += fp->f_hits;
			if (fp->f_hits > maxhits)
				maxhits = fp->f_hits;
			if (++fp >= &ftn[MAXFTN])
				break;
		}
	}
	if (maxhits == 0) {
		fprintf(stderr, "No samples\n");
		exit(1);
	}
	nftn = fp - ftn;
        qsort(ftn, nftn, sizeof(*fp), compar);

	if (tflg)
                printf("User time: %8.03f\n\n", usrtime);
	lnwidth = (tflg)? TWIDTH: LNWIDTH;
	eftn = &ftn[nftn];
	for (fp = ftn; fp < eftn; fp++) {
		if ((bar = fp->f_hits*lnwidth/maxhits) == 0) {
			otherhits += fp->f_hits;
			continue;
		}
		printf("%-10s%4.01f  ", fp->f_name, fp->f_hits*100/(float) tothits);
                if (tflg)
                        printf("%5.03f  ", usrtime*fp->f_hits/(float) tothits);
		for (i = 0; i < bar; i++)
			putchar(STAR);
		putchar('\n');
        }
	bar = otherhits*lnwidth/maxhits;
        printf("%-10s%4.01f  ", "other", otherhits*100/(float) tothits);
        if (tflg)
                printf("%5.03f  ", usrtime*otherhits/(float) tothits);
        for (i = 0; i < bar; i++)
                putchar(STAR);
        putchar('\n');
	printf("\ntotal samples: %d\n", tothits);
}

compar(x, y)
struct  f       *x;
struct  f       *y;
{
	if (fflg)
		return(strcmp(x->f_name, y->f_name));
	else
		return(y->f_hits - x->f_hits);
}
