#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#define LINESIZE 512
#define min(a, b)  ((a < b)? a: b)

int status;
char *compiler, *loader;
int cargc, largc;
char **cargv, **largv;
char mccnedF[40];
char tmpa[15], tmpb[30];

char *fgets(), *strend(), *sname();
int quit();

main(argc, argv)
int argc;
char *argv[];
{
        int pid, nfiles, i;
	int loadneeded;
	char *cmd, *preproc, *suffix, *p, *type, *dotohfile;

	signal(SIGHUP, quit);
	signal(SIGINT, quit);
	signal(SIGQUIT, quit);
	signal(SIGTERM, quit);
	setbuf(stdout, NULL);
	sprintf(tmpa, "/tmp/mXXXXXX");
	mktemp(tmpa);
	strcpy(mccnedF, getenv("HOME"));
	strcat(mccnedF, "/.../mcc");
	if (access(mccnedF, 4) < 0)
		strcpy(mccnedF, "/usr/lib/mcc");
	/*
	 * determine the name of the command, 
	 * which compiler and loader to call, 
	 * the preprocessor option, 
	 * and the suffix of files to compile.
	 *
	 * qs has mcc as its loader so that
	 *      mqs try.q att.c
	 * will do an mcc on att.c
	 */
	cmd = sname(argv[0]);
	if (strcmp(cmd, "mcc") == 0) {
		compiler = "/bin/cc";
		loader = "/bin/cc";
		preproc = "-P";
		suffix = ".c";
	} else if (strcmp(cmd, "mqs") == 0) {
		compiler = "/bin/qs";
		loader = "/bin/mcc";
		preproc = "-q";
		suffix = ".q";
	} else if (strcmp(cmd, "mncc") == 0) {
		compiler = "/bin/ncc";
		loader = "/bin/ncc";
		preproc = "-P";
		suffix = ".c";
	} else
		error("unknown compiler\n");
	/*
	 * Two arrays of character pointers are set up, 
	 * cargv for compiler argv and largv for loader argv.
	 * They will both contain pointers that were in the
	 * original argv.
	 *
	 * if the user typed:
	 *   mcc  -O  try.c  -DN=4  /tmp/t.c  tt.o  -o t -lpw
	 * then cargv would contain:
	 *   cc  -c  -O  -DN=4  X  0
	 *        (the names of the .c files would replace the X.)
	 * and largv would contain:
	 *   cc  -O  try.o  -DN=4  t.o  tt.o  -o t -lpw  0
	 *
	 * Space is allocated for cargv and largv.
	 * The worst case is handled properly.
	 * We do a argc+2 because for cargv there is the "-c" and the 0.
	 * For largv there is the "-lq" to be added for mqs and the 0.
	 *
	 * Options that are commonly used loader flags (-o and -l?) are
	 * not put in cargv.
	 * Files that end in the suffix will be changed to .o before
	 * the loader is actually called.
	 * CC always makes the .o file in the CURRENT directory.
	 */
	cargv = calloc(argc+2, 4);
	largv = calloc(argc+2, 4);
	cargv[0] = sname(compiler);
	cargv[1] = "-c";
	cargc = 2;
	largv[0] = sname(loader);
	largc = 1;
	loadneeded = 1;
	nfiles = 0;
	for (i = 1; i <= argc-1; ++i) {
		largv[largc++] = p = argv[i];
		if (*p == '-') {
			if (strcmp(p, "-c") == 0)
				loadneeded = 0;
			else if (strcmp(p, preproc) == 0) {
				loadneeded = 0;
				cargv[cargc++] = p;
			} else if (strcmp(p, "-o") != 0 &&
                                   strncmp(p, "-l", 2) != 0   )
				cargv[cargc++] = p;
		} else if (strcmp(strend(p)-2, suffix) == 0)
			++nfiles;
	}
	cargv[cargc+1] = 0;
        for (i = 1; i <= argc-1; ++i) {
		p = argv[i];
                if (strcmp(strend(p)-2, suffix) == 0) {
                        if (access(p, 4) < 0) {
                                printf("%s: not found\n", p);
                                loadneeded = 0;
                        } else {
                                if (nfiles > 1)
                                        printf("%s:\n", p);
				cargv[cargc] = p;
                                mergecompile();
                        }
		}
	}
        if (loadneeded) {
		for (i = 1; i <= largc-1; ++i) {
			type = strend(largv[i])-2;
			if (strcmp(type, suffix) == 0) {
				strcpy(type, ".o");
				largv[i] = sname(largv[i]);
				if (nfiles == 1)
					dotohfile = largv[i];
			}
		}
		if (strcmp(cmd, "mqs") == 0)
			largv[largc++] = "-lq";
		largv[largc] = 0;
		load();
		if (nfiles == 1)
			unlink(dotohfile);
	}
	unlink(tmpa);
	exit(status != 0);
}

quit(sig)
int sig;
{
	signal(sig, SIG_IGN);
	unlink(tmpa);
	unlink(tmpb);
	exit(1);
}

mergecompile()
{
	int i;
	char *source;
	char tmpout[40];

	source = cargv[cargc];
	maketmpb(source);
	maketmpout(source, tmpout);
	while (1) {
		compile();
		if (status == 0)
			break;
		if (merge(tmpa, source, tmpb) < 0)
			break;
		ned(tmpb);
                /*
                 * ned returns a status of 2 in cases of errors like not
                 * being able to open the tube. someone may be running mcc
                 * in the background and be in a full screen program in
                 * the foreground. terminate if this happens.
		 *
		 * a status of 0 means that no write was done in ned.
		 * we should also quit on this because there WERE errors
		 * in the source that needed correcting.
		 *
		 * a status of 1 means a succesful write was done.
                 */
		if (status != 1)
                        quit();
                printf(": ");
		for (i = 0; i <= cargc; ++i)
			printf("%s ", cargv[i]);
		printf("\n");
		filter(tmpb, tmpout, source);
	}
	unlink(tmpb);
}

maketmpb(source)
char *source;
{
	char *p;
	char append;

	p = sname(source);
	sprintf(tmpb, "/tmp/%.14s", p);
	if (access(tmpb, 4) < 0)
		return;
	sprintf(tmpb, "/tmp/%.13s ", p);
	if (access(tmpb, 4) < 0)
		return;
	append = 'A';
	for (append = 'A'; append <= 'Z'; append++) {
		sprintf(tmpb, "/tmp/%.12s.%c", p, append);
		if (access(tmpb, 4) < 0)
			return;
	}
	error("cannot create tmpb\n");
}

/*
 * make a filename in t from s.
 * take up to 12 chars from the last component of s and then append X's.
 * then call mktemp to make sure it is unique.
 */

maketmpout(s, t)
char *s, *t;
{
	int nc, nX;
	char *p, *q;

	p = sname(s);
	nc = min(12, strlen(p));
	nX = min(6, 14-nc);
	q = t;
	while (s < p)
		*q++ = *s++;
	while (nc--)
		*q++ = *p++;
	while (nX--)
		*q++ = 'X';
	*q = 0;
	mktemp(t);
}

compile()
{
	int pid, rpid, fd;

	if ((pid = fork()) < 0)
		error("could not fork\n");
	if (pid == 0) {
                close(1);                  /* redirect stdout     */
                fd = creat(tmpa, 0600);     /* to the file tmpa */
		close(2);                  /* and stderr          */
                dup(fd);                   /* to the same file    */
		execv(compiler, cargv);
		error("could not exec %s\n", compiler);
	}
	while ((rpid = wait(&status)) != pid && rpid >= 0)
                ;
	if (rpid < 0)
		error("no child to wait for\n");
	status >>= 8;
}

merge(dn, sn, mn)
char *dn, *sn, *mn;
{
	/*
	 * d, s, and m stand for diagnostic, source, and merged
	 */
	FILE *df, *sf, *mf;
	int dl, sl;
	char d[LINESIZE], s[LINESIZE];
	char *p, *q;
	char name[40];
	int extra, i;

	if ((df = fopen(dn, "r")) == NULL)
		error("could not open %s\n", dn);
	if ((sf = fopen(sn, "r")) == NULL)
		error("could not open %s\n", sn);
	if ((mf = fopen(mn, "w")) == NULL)
		error("could not open %s\n", mn);
	/*
	 * Error messages have this form:
	 *
	 *  filename: lineno: message
	 *
	 * "extra" messages may be C errors in an included file, 
	 * errors from the assembler, or (quite possibly)
	 * an erroneous error message.
	 */
	extra = 0;
	sl = 0;
	while (fgets(d, LINESIZE, df) != NULL) {
		p = d;
		q = name;
		while (*p && *p != ':')
			*q++ = *p++;
		*q = 0;
	        if (*p != ':' || strcmp(name, sn) != 0) {
			extra = 1;
			puts(d);
			continue;
		}
		++p;
		while (*p == ' ')
			++p;
		dl = 0;
		while (*p && isdigit(*p)) {
			dl = 10*dl + (*p-'0');
			++p;
		}
		if (*p != ':') {
			extra = 1;
			puts(d);
		        continue;
		}
		/*
		 * We have an error message for the file we cc'ed.
		 * Copy the source until you pass the right line
		 */
		while (sl < dl && fgets(s, LINESIZE, sf) != NULL) {
			if (*s == ':') {
				fprintf(stderr, "%s\nThe above line from the file %s begins with\n",
                                                s, sn);
				fprintf(stderr, "a colon which has a special meaning to mcc.\n");
				fprintf(stderr, "You must fix this before mcc can continue.\n");
			        return(-1);
			}
			fputs(s, mf);
			++sl;
		}
                /*
                 * and put the error message out.
                 */
		fputs(p, mf);
	}
	/*
	 * Copy the rest of the source.
	 */
	while (fgets(s, LINESIZE, sf) != NULL)
		fputs(s, mf);
	fclose(df);
	fclose(sf);
	fclose(mf);
	/*
	 * if there were some extra diagnostics make it so
	 * the screen has to be cleared before going on to ned.
	 */
	if (extra)
		for (i = 1; i <= 23; ++i)
			putchar('\n');
	return(0);
}

ned(fname)
char *fname;
{
	int pid, rpid;

	if ((pid = fork()) < 0)
		error("could not fork\n");
	if (pid == 0) {
		execl("/bin/ned", "ned", "-F", mccnedF, fname, 0);
		error("could not execl /bin/ned\n");
	}
	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGTERM, SIG_IGN);
	while ((rpid = wait(&status)) != pid && rpid >= 0)
		;
	if (rpid < 0)
		error("no child to wait for\n");
	status >>= 8;
	signal(SIGHUP, quit);
	signal(SIGINT, quit);
	signal(SIGQUIT, quit);
	signal(SIGTERM, quit);
}

filter(in, out, dest)
char *in, *out, *dest;
{
	FILE *inf, *outf;
	char line[LINESIZE];
	struct stat statbuf;

	if ((inf = fopen(in, "r")) == NULL)
		error("could not open %s\n", in);
	if ((outf = fopen(out, "w")) == NULL)
		error("could not open %s\n", out);
	while (fgets(line, LINESIZE, inf) != NULL)
		if (*line != ':')
		        fputs(line, outf);
	fclose(inf);
	fclose(outf);
	if (stat(dest, &statbuf) < 0)
		error("cannot stat %s\n", dest);
	if (chmod(out, statbuf.st_mode) < 0)
		error("cannot chmod %s\n", out);
	/*
	 * Dan helped me with the following.
	 * It insures that the source will not be lost.
	 */
	sync();
	unlink(dest);
	if (link(out, dest) < 0)
		error("could not link %s to %s\n", out, dest);
	sync();
	unlink(out);
}

load()
{
	int pid, rpid;

	if ((pid = fork()) < 0)
		error("could not fork\n");
	if (pid == 0) {
		execv(loader, largv);
		error("could not execv %s\n", loader);
	}
	while ((rpid = wait(&status)) != pid && rpid >= 0)
		;
	if (rpid < 0)
		error("no child to wait for\n");
	status >>= 8;
}

char *
fgets(s, n, f)
char *s;
int n;
FILE *f;
{
        char *os;
        int c;

        os = s;
        while (n > 0 && (c = getc(f)) != '\n' && c != EOF) {
                *s++ = c;
                --n;
        }
        if (n <= 0) {
		*s = 0;
		printf("not enough room for chars in fgets\n%s\n", os);
                exit(1);
        } else if (c == EOF)
                return(NULL);
        else {
                *s = 0;
                return(os);
        }
}

fputs(s, f)
char *s;
FILE *f;
{
	while (*s)
		putc(*s++, f);
	putc('\n', f);
}

error(arglist)
int *arglist;
{
        fprintf(stderr, "mcc: %r", &arglist);
        exit(1);
}
