#include <stdio.h>
#include <sys/param.h>
#include <sys/filsys.h>
#include <sys/fblk.h>
#include <sys/stat.h>
#include <sys/dir.h>

daddr_t	blkno	= 1;

struct	filsys sblock;

int     fi;
daddr_t	alloc();
char entry[20];
extern char *cmdname;

main(argc, argv)
int     argc;
char    *argv[];
{
	int     i, found;
	char    buf[64];
	int     fd;
	char    *sname();

	fd = open("/etc/mtab", 0);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open /etc/mtab\n", cmdname);
		exit(1);
	}
	printf("disk           total   %% full   free   file system\n");
	if (argc <= 1) {
		while (read(fd, buf, sizeof(buf)) == sizeof(buf)) {
			if (buf[32] != '\0') {
				buf[26] = '\0';
				buf[27] = '/';
				buf[28] = 'd';
				buf[29] = 'e';
				buf[30] = 'v';
				buf[31] = '/';
				dfree(&buf[0], &buf[27]);
			}
		}
	} else {
		for(i=1; i<argc; i++) {
			if (strcmp(argv[i], ".") == 0) {
				finddev(&argv[i]);
			}
			seek(fd, 0, 0);
			found = 0;
			while (read(fd,buf,sizeof(buf)) == sizeof(buf)) {
				buf[26] = '\0';
				buf[27] = '/';
				buf[28] = 'd';
				buf[29] = 'e';
				buf[30] = 'v';
				buf[31] = '/';
				if (strcmp(argv[i],       buf    ) == 0
				||  strcmp(argv[i], sname(buf)   ) == 0
				||  strcmp(argv[i],      &buf[27]) == 0
				||  strcmp(argv[i],      &buf[32]) == 0) {
					dfree(&buf[0], &buf[27]);
					found++;
				}
			}
			if (!found) {
				fprintf(stderr,
					"%s: unknown file system: %s\n",
					cmdname, argv[i]);
			}
		}
	}
}

finddev(arg)
char **arg;
{
	struct stat buf;
	dev_t device;
	int fdev;
	struct direct dir;

	if (stat(*arg, &buf) < 0) {
		return;
	}
	device = buf.st_dev;
	if ((fdev = open("/dev", 0)) == 0) {
		return;
	}
	strcat(entry, "/dev/");
	entry[19] = '\0';
	while (read(fdev, (char *) &dir, sizeof(dir)) > 0) {
		strncpy(&entry[5], dir.d_name, 14);
		if (stat(entry, &buf) >= 0 && buf.st_rdev == device) {
			*arg = entry;
			break;
		}
	}
	close(fdev);
}

dfree(dir, file)
char *dir, *file;
{
	daddr_t i;

	fi = open(file, 0);
	if(fi < 0) {
		fprintf(stderr,"%s: cannot open %s\n", cmdname, file);
		return;
	}
	sync();
	bread(1, (char *)&sblock, sizeof(sblock));
	i = 0;
	if (sblock.s_nfree)
		while(alloc())
			i++;
	printf("%-11s %8d%8.01f%8d   %s\n",
		file, sblock.s_fsize, 100.-100.*i/sblock.s_fsize, i, dir);
	close(fi);
}

daddr_t
alloc()
{
	int i;
	daddr_t b;
	struct fblk buf;

	i = --sblock.s_nfree;
	if (i < 0 || i >= NICFREE) {
		printf("%s: bad free count, b=%d\n", cmdname, blkno);
		return(0);
	}
	b = sblock.s_free[i];
	if(b == 0)
		return(0);
	if(b<sblock.s_isize || b>=sblock.s_fsize) {
		printf("%s: bad free block (%d)\n", cmdname, b);
		return(0);
	}
	if(sblock.s_nfree <= 0) {
		bread(b, (char *)&buf, sizeof(buf));
		blkno = b;
		sblock.s_nfree = buf.df_nfree;
		for(i=0; i<NICFREE; i++)
			sblock.s_free[i] = buf.df_free[i];
	}
	return(b);
}

bread(bno, buf, cnt)
daddr_t bno;
char *buf;
{
	int n;
	extern errno;

	seek(fi, bno<<BSHIFT, 0);
	if((n=read(fi, buf, cnt)) != cnt) {
		printf("%s: read error %d\n", cmdname, bno);
		printf("count = %d; errno = %d\n", n, errno);
		exit(1);
	}
}
