#include "dcon.h"
#include "ops.c"

/*
 * print an instruction, decoding it from the object
 */

prinst(addr, flag)
register int addr;
int flag;{

	register w, x;
	register struct optab *pop;
	int sysp, otype;

	w = peek(map(addr));
	switch(x = w.opcode) {
		case BC:
			pop = brlookup(w.r1, BRANCH);
			break;
		case BCR:
			pop = brlookup(w.r1, BRANCHR);
			break;
		case SVC:
			x = (w.r1 << 4) | w.r2;
			if ((sysp = syslookup(x)) != -1)
				fprintf(out, "sys\t%s", sys[sysp].sys_name);
			else fprintf(out, "svc\t%d", x);
			instlen = BPHW;
			return;
		default:
			if ((pop = oplookup(x)) == NULL)
				if (w.sopcode > 0xff) pop = oplookup(w.sopcode);
			break;
		}
	if (pop == NULL) {
		fprintf(out, "%8x", w);
		instlen = BPHW;
		return;
		}
	otype = pop->op_type;
	if (flag) {
		if (otype==SS1 || otype==SS2 || otype==SS3)
			fprintf(out, "%8x%4x\t", w, peek(map(addr+BPW)) >> 16);
		else if (otype==RR || otype==BRANCHR)
			fprintf(out, "%4x%8c\t", w.sopcode, ' ');
		else fprintf(out, "%8x%4c\t", w, ' ');
		}
	fprintf(out, "%s\t", pop->op_name);
	switch(otype) {
		case RR:
			instlen = BPHW;
			fprintf(out, "r%d,r%d", w.r1, w.r2);
			break;
		case RX:
			instlen = BPW;
			fprintf(out, "r%d,", w.r1);
			prtaddr(w.r2, w.base1, w.disp1);
			break;
		case RS1:
			instlen = BPW;
			fprintf(out, "r%d,r%d,", w.r1, w.r2);
			prtaddr(w.base1, 0, w.disp1);
			break;
		case RS2:
			instlen = BPW;
			fprintf(out, "r%d,", w.r1);
			prtaddr(w.base1, 0, w.disp1);
			break;
		case SI1:
			instlen = BPW;
			prtaddr(w.base1, 0, w.disp1);
			fprintf(out, ",%d", (w.r1 << 4) | w.r2);
			break;
		case SI2:
			instlen = BPW;
			prtaddr(w.base1, 0, w.disp1);
			break;
		case S:
			instlen = BPW;
			if (w.disp1) prtaddr(w.base1, 0, w.disp1);
			break;
		case SS1:
		case SS2:
			instlen = BPW+BPHW;
			x = peek(map(addr+BPW));
			prtaddr(w.r1, w.base1, w.disp1);
			putchar(',');
			prtaddr(w.r2, x.base2, x.disp2);
			break;
		case SS3:
			instlen = BPW+BPHW;
			x = peek(map(addr+BPW));
			prtaddr(w.r1, w.base1, w.disp1);
			putchar(',');
			prtaddr(x.base2, 0, x.disp2);
			fprintf(out, ",%d", w.r2);
			break;
		case BRANCH:
			instlen = BPW;
			prtaddr(w.r2, w.base1, w.disp1);
			break;
		case BRANCHR:
			instlen = BPHW;
			fprintf(out, "r%d", w.r2);
			break;
		}
	}

prtaddr(x, b, d)
register int x, b, d;{

	if (x == 0) {
		fprintf(out, "%d(,r%d)", d, b);
		}
	else if (b == 0)
		fprintf(out, "%d(r%d)", d, x);
	else fprintf(out, "%d(r%d,r%d)", d, x, b);
	}

struct optab *oplookup(x)
register int x;{

	register int i, j, k;

	i = 0; j = NUMOPS-1;
	while (j >= i){
		k = (i+j)/2;
		if (op[k].op_val == x) return(&op[k]);
		else if (op[k].op_val < x) i = k+1;
		else j = k-1;
		}
	return(NULL);
	}

syslookup(n)
register int n;{

	register int i, j, k;

	i = 0; j = NUMSYS-1;
	while (j >= i){
		k = (i+j)/2;
		if (sys[k].sys_svcno == n) return(k);
		else if (sys[k].sys_svcno < n) i = k+1;
		else j = k-1;
		}
	return(-1);
	}

struct optab *brlookup(x, y)
register int x, y;{

	register int i;

	for (i = 0; i <= NUMBRS; i++){
		if (br[i].op_val == x && br[i].op_type == y)
			return(&br[i]);
		}
	return(NULL);
	}
