%token NUMBER LETTER ACC CMD SKIP /* these are token names */
%left '|'                /* declarations of operator precedences */
%left '~'
%left '&'
%left RSHFT LSHFT
%left '+' '-' '\''
%left '*' '/' '%'
%right POW
%left UMINUS             /* supplies precedence for unary minus */
%left SIN COS ATAN EXP LOG
%{                       /* declarations used by the actions */
#define MAXROM 39999       /* maximum roman number */
#define NUMI 1
#define NUMF 2
	struct  num{
                long    numi;
		double  numf;
		int     tag;
	};
	struct  num     num[100];
	int     nalloc;
	struct  num     acc;
	struct  num     regs[26];
	char    outconv;
	int     fprec 9;
	char    fconv 'g';
	char    format[25];
	int     errflg;
%}

%%      /* beginning of rules section */

list:           /* list is the start symbol */
	|       /* empty */
	list stat |
	list skip |
	list error '\n' =
	{
                yyerrok;
		errflg = 0;
		nalloc = 0;
	};

stat:
	expr '\n' =
	{
		if (!errflg)
		        print($1);
		errflg = 0;
	} |
	LETTER '=' expr '\n' =
	{
		assign($1, $3);
	};

expr:
	'(' expr ')' =
	{
		$$ = $2;
	} |
	expr '+' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '\'' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '-' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '*' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '/' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '&' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr LSHFT expr =
	{
		$$ = eval($1, LSHFT, $3);
	} |
	expr RSHFT expr =
	{
		$$ = eval($1, RSHFT, $3);
	} |
	expr '|' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr '%' expr =
	{
		$$ = eval($1, $2, $3);
	} |
	expr POW expr =
	{
		$$ = eval($1, POW, $3);
	} |
	'-' expr %prec UMINUS
	{
		$$ = eval (alloci(0L), '-',  $2);
	} |
	'~' expr
	{
		$$ = eval (alloci(0L), $1,  $2);
	} |
	SIN expr
	{
		$$ = eval (allocf(0.0), SIN,  $2);
	} |
	COS expr
	{
		$$ = eval (allocf(0.0), COS,  $2);
	} |
	ATAN expr
	{
		$$ = eval (allocf(0.0), ATAN,  $2);
	} |
	EXP expr
	{
		$$ = eval (allocf(0.0), EXP,  $2);
	} |
	LOG expr
	{
		$$ = eval (allocf(0.0), LOG,  $2);
	} |
	LETTER
	{
		$$ = getreg($1);
	} |
	ACC
	{
		$$ = getacc();
	} |
	NUMBER;

skip:
        SKIP '\n' =
	{
		print(&acc);
	};

%%      /* start of programs */

#include <stdio.h>
#include "lex.yy.c"

print(n)
struct  num     *n;
{
	register i;
	char    str[20];

	if (n->tag == NUMI) {
	        switch(outconv) {
	        case 'x':
			sprintf(str, "%lx", n->numi);
			printf("  %s\n", uptolow(str));
			break;
		case 'X':
		        printf("  %lx\n", n->numi);
		        break;
	        case 'o':
		        printf("  %lo\n", n->numi);
		        break;
	        case 'r':
			rompr(n->numi, 0);
		        break;
	        case 'R':
			rompr(n->numi, 1);
		        break;
	        default:
	        case 'd':
		        printf("  %ld\n", n->numi);
		        break;
	        }
		acc.tag = NUMI;
	        acc.numi = n->numi;
	} else {
		sprintf(format, "  %%.%dl%c\n", fprec, fconv);
		printf(format, n->numf);
		acc.tag = NUMF;
	        acc.numf = n->numf;
	}
}
rompr(n, up)
long    n;
int     up;
{
	register i;

        if (n >= 0 && n <= MAXROM)
                printf("  %s\n", itor(i = n, up));
        else if (n < 0 && n >= -MAXROM)
                printf("  negativus %s\n", itor(-(i = n), up));
	else {
	        printf("  ?\n");
	        errflg = 1;
	}
}

uptolow(cp)
register char *cp;
{
	register char *r;

	r = cp;
	do {
		if (*cp >= 'A' && *cp <= 'Z')
			*cp = *cp - 'A' + 'a';
	} while (*++cp);
	return(r);
}

assign(c, n)
struct num *n;
{
	regs[c].tag = n->tag;
        regs[c].numi = n->numi;
        regs[c].numf = n->numf;
}
eval(n1, op, n2)
register struct num *n1, *n2;
{
	int     i;
	double  f1, f2, fr;
	double  sin(), cos(), atan(), exp(), log();

	if (n1->tag == NUMI && n2->tag == NUMI && op != POW) {
	        switch(op) {
	        case '+':
	        case '\'':
		        return(alloci(n1->numi + n2->numi));
	        case '-':
		        return(alloci(n1->numi - n2->numi));
	        case '*':
		        return(alloci(n1->numi * n2->numi));
	        case '/':
		        return(alloci(n1->numi / n2->numi));
	        case '&':
		        return(alloci(n1->numi & n2->numi));
	        case LSHFT:
		        return(alloci(n1->numi << n2->numi));
	        case RSHFT:
		        return(alloci(n1->numi >> n2->numi));
	        case '|':
		        return(alloci(n1->numi | n2->numi));
	        case '%':
		        return(alloci(n1->numi % n2->numi));
	        case '~':
		        return(alloci(~n2->numi));
	        default:
		        printf("  ?\n");
                        errflg = 1;
		        return(alloci(0L));
	        }
	} else {
		if (n1->tag == NUMI)
			f1 = n1->numi;
		else
			f1 = n1->numf;
		if (n2->tag == NUMI)
			f2 = n2->numi;
		else
			f2 = n2->numf;
		switch(op) {
		case '+':
			fr = f1 + f2;
			break;
		case '-':
			fr = f1 - f2;
			break;
		case '*':
			fr = f1 * f2;
			break;
		case '/':
			fr = f1 / f2;
			break;
		case '%':
			i = f1 / f2;
			fr = f1 - i * f2;
			break;
		case SIN:
			fr = sin(f2);
			break;
		case COS:
			fr = cos(f2);
			break;
		case ATAN:
			fr = atan(f2);
			break;
		case EXP:
			fr = exp(f2);
			break;
		case LOG:
			fr = log(f2);
			break;
		case POW:
			fr = log(f1);
			fr = exp(fr * f2);
			break;
		default:
			printf("  ?\n");
			errflg = 1;
			fr = 0.0;
			break;
		}
		return(allocf(fr));
	}
}
getacc()
{
        return(&acc);
}
getreg(r)
{
        return(&regs[r]);
}
yyerror()
{
	printf("  ?\n");
}

alloci(i)
long    i;
{
	if (nalloc > 99) {
		printf("overflow\n");
		exit();
	}
	num[nalloc].tag = NUMI;
	num[nalloc].numi = i;
	return(&num[nalloc++]);
}

allocf(f)
double  f;
{
	if (nalloc > 99) {
		printf("overflow\n");
		exit();
	}
	num[nalloc].tag = NUMF;
	num[nalloc].numf = f;
	return(&num[nalloc++]);
}
