#include <stdio.h>
#include "sym.h"
#include "opcodes.h"
#include "assem.h"
#include "numlab.h"
#include "error.h"
#include "scanner.h"


/*
 * pass 2 of assembler
 */

#define NULLIP  (int *)0
static int utop;
struct using_table using[MAXUSING];

pass2() {

	register SYM *op;
	TOKEN nxttoke;
	struct exp e;
	register TOKEN *tp;

	tp = &curtoke;
	scan2(tp, 0);
	while (tp->t_state != END){
		onerror();
		if (tp->t_state == ID){
			if (tp->t_val == -1) op = NULL;
			else op = tp->t_sym;
			scan2(&nxttoke, 0);
			switch(nxttoke.t_state){
				case ':':
					scan2(tp, 0);
					continue;
				case '=':
				        /*
					 * S, SS, and SI instruction names are reserved
					 * keywords and cannot be used in equates.
					 */
					if (op != NULL && (op->s_type == S ||
					      op->s_type==SI1 || op->s_type==SI2 ||
					      op->s_type==SS1 || op->s_type==SS2 ||
					      op->s_type==SS3))
						goto norm;
					gobble();
					continue;
				default:
				    norm:
					move((char *)&nxttoke, (char *)tp, sizeof(nxttoke));
					if (op != NULL) do2(op);
					else error(1, "Intermediate file error");
					break;
				}
			}
		else if (tp->t_state == DIG){
			scan2(&nxttoke, 0);
			if (nxttoke.t_state == ':'){
				fbadv(tp->t_val);
				}
			else error(0, "Missing opcode");
			}
		else if (tp->t_state == ADOT){
			scan2(&curtoke, 0);
			scan2(&curtoke, 0);
			expres(&e);
			fflush(outfil);
			orel = dotrel;
			if (dotrel != BSSSEG && size[dotrel-TEXTSEG] != -1)
				fseek(outfil, oseek[0]+e.e_val, 0);
			if (e.e_type == ABSOLUTE) dot = e.e_val;
			else dot = e.e_val-oseek[dotrel-TEXTSEG]+oseek[0];
			}
		else if (tp->t_state != NEWLINE)
			error(-1, "Bad opcode");
		scan2(tp, 0);
		}
	utop = dotrel;
	chdot(TEXTSEG);
	dumplits();
	chdot(utop);
	dot = align(dot, BPD);
	chdot(dotrel);
	fflush(outfil);
	}

/*
 * pass 2 scanner, doesn't have much to do
 */

scan2(s, flag)
register TOKEN *s;
int flag;{

	register int c;
	register char *p;

	c = getw(txtfil);
	if (c == USYMSTART){
		s->t_state = ID;
		s->t_val = -1;
		s->t_sym = (SYM *) getw(txtfil);
		return;
		}
	else if (c == SYMSTART){
		s->t_state = ID;
		s->t_val = 0;
		s->t_sym = (SYM *) getw(txtfil);
		return;
		}
	s->t_state = c;
	switch(c) {
		case DIG:
		case ABS:
			s->t_val = getw(txtfil);
			return;
		case BIN:
		case HEX:
		case CHAR:
			s->t_val = getw(txtfil);
			for (p = s->t_name; p < s->t_name+s->t_val;)
				*p++ = getc(txtfil);
			*++p = '\0';
			if (getc(txtfil) != SQS) error(1, "Sequence error");
			s->t_namep = p-(s->t_name);
			return;
		case FQ:
		case HQ:
			s->t_val = getw(txtfil);
			return;
		case NEWLINE:
			lineno++;
			return;
		case ';':
			s->t_state = NEWLINE;
			return;
		case START:
			curarg++;
			lineno = 1;
			scan2(s, flag);
			return;
		case EOF:
			s->t_state = END;
			return;
		}
	}

/*
 * do2 - process the pseudo-ops for pass 2
 */

do2(op)
SYM *op;{

	register int n;
	int nlst;
	int opv, count, length;
	struct exp e;
	SYM *symp;
	char *p, cval[LINESIZE];
	char *plst;
	register TOKEN *tp;
	register struct exp *ep;

	tp = &curtoke;
	ep = &e;
	opv = op->s_val;
	if (op->s_type == BRANCH) opv = BC;
	else if (op->s_type == BRANCHR) opv = BCR;
	symp = tp->t_sym;
	switch(opv) {
		case TEXT:
			chdot(TEXTSEG);
			break;
		case DATA:
			chdot(DATASEG);
			break;
		case BSS:
			chdot(BSSSEG);
			break;
		case CSECT:
		case DSECT:
			chdot(symp->s_type);
			break;
		case COMM:
		case WXTRN:
		case DENTRY:
		case ENTRY:
		case EXTRN:
			gobble();
			break;
		case CSYM:
			csym(tp);
			break;
		case CLINENO:
			putc(CLINECH, symfil);
			puthw(tp->t_val, symfil);
			putw(dot, symfil);
			break;
		case CBLOCK:
			putc(CBLKCH, symfil);
			puthw(tp->t_val, symfil);
			break;
		case CFUNC:
		case CFILE:
			fputs(symp->s_name, symfil);
			putc('\0', symfil);
			break;
		case DC:
			for (;;){
				dc2(ep, cval);
				count = ep->e_val;
				length = ep->e_len;
				switch(ep->e_type & LOCAL){
					case CABS:
					case HABS:
					case BABS:
				                if (listflg) {
							objwrd(dot);
							objwrd(length*count);
						}
						while (count--){
					                if (listflg) {
								plst = cval;
								nlst = length;
								while (nlst--)
									objchar(*plst++);
							}
							p = cval;
							n = length;
							while (n--){
								putob(*p++);
								}
							dot += length;
							}
						break;
					default:
						dot = align(dot, length);
				                if (listflg) {
							objwrd(dot);
							objwrd(length*count);
						}
						while (count--){
					                if (listflg) {
								plst = cval;
								nlst = length;
								if (nlst < BPW)
									plst += BPW-nlst;
								while (nlst--)
									objchar(*plst++);
							}
							p = cval;
							n = length;
							if (n < BPW)
								p += BPW-n;
							while (n--) putob(*p++);
							genreloc(dot,length,ep);
							dot += length;
							}
						break;
					}
				if (tp->t_state != ',') break;
				scan2(tp, 0);
				}
			break;
		case DS:
			for (;;){
				ds2(ep);
				opv = ep->e_val*ep->e_len;
				dot = align(dot, ep->e_len);
				if (listflg)
					outds(dot, opv);
				for (n = 0; n < opv; n++)
					putob(0);
				dot += opv;
				scan2(tp, 0);
				if (tp->t_state != ',') break;
				scan2(tp, 0);
				}
			break;
		case ENDOP:
			dumplits();
			dot = align(dot, BPD);
			chdot(TEXTSEG);
			gobble();
			break;
		case LTORG:
			dumplits();
			break;
		case USING:
			if (expres(ep) != ',')
				error(0, "Bad address expression");
			length = ep->e_val;
			ep->e_type &= LOCAL;
			if (ep->e_type == UNDEFINED)
				error(0, "Undefined symbol");
			if (ep->e_type == ABSOLUTE) ep->e_type = dotrel;
			while (tp->t_state == ','){
				scan2(tp, 0);
				opv = getabs(0, 15);
				for (n = 0; n < utop; n++){
					if (using[n].reg == opv){
						using[n].addr = length;
						using[n].u_rel = ep->e_type;
						break;
						}
					}
				for (n = 0; n < utop; n++){
					if (using[n].reg == -1){
						using[n].reg = opv;
						using[n].addr = length;
						using[n].u_rel = ep->e_type;
						break;
						}
					}
				if (n == utop)
					if (n >= MAXUSING)
						error(0, "Out of using regs");
					else {
						using[utop].reg = opv;
						using[utop].addr = length;
						using[utop].u_rel = ep->e_type;
						utop++;
						}
				length += MAXDISP;
				}
			if (tp->t_state != NEWLINE)
				error(0, "Missing newline");
			break;
		case DROP:
			if (tp->t_state == NEWLINE){
				for (n = 0; n < MAXUSING; n++)
					using[n].reg = -1;
				utop = 0;
				break;
				}
			do {
				opv = getabs(0, 15);
				for (n = 0; n < utop; n++){
					if (using[n].reg == opv){
						using[n].reg = -1;
						if (n == utop-1) --utop;
						}
					}
				} while (tp->t_state == ',');
			break;
		case SVC:
			n = getabs(0, 255);
			dot = align(dot, BPH);
			putob(SVC);
			putob(n);
			if (listflg) {
			        putw(dot, textobj);
			        putw(SVC, textobj);
			        putw(n, textobj);
			}
			dot += BPH;
			break;
		case SPM:
			n = getabs(0, 15);
			dot = align(dot, BPH);
			if (listflg) {
			        putw(dot, textobj);
			        putw(SPM, textobj);
			        putw(n << 4, textobj);
			}
			putob(SPM);
			putob(n << 4);
			dot += BPH;
			break;
		case CNOP:
			dot = align(dot, BPH);
			opv = getabs(0, BPD-2);
			scan2(tp, 0);
			n = getabs(BPW, BPD);
			n = (dot+n-1)/n*n-dot+opv;
			while (n > 0) {
				if (listflg) {
					objwrd(dot);
					objwrd(BCR);
					objwrd(0);
			        }
				putob(BCR);
				putob(0);
				dot += BPH;
				n -= BPH;
				}
			if (listflg)
				objwrd(-1);
			break;
		case CCW:
			dot = align(dot, BPD);
			expres(ep);
			if ((ep->e_type & LOCAL) != ABSOLUTE)
				error(0, "Expression must be absolute");
			if (listflg) {
		                putw(dot, dataobj);
		                putc(ep->e_val, dataobj);
			}
			putob(ep->e_val);
			scan2(tp, 0);
			expres(ep);
			if (listflg) {
		                putc(ep->e_val & 0x00ff0000, dataobj);
		                putc(ep->e_val & 0x0000ff00, dataobj);
		                putc(ep->e_val & 0x000000ff, dataobj);
			}
			putob(ep->e_val & 0x00ff0000);
			putob(ep->e_val & 0x0000ff00);
			putob(ep->e_val & 0x000000ff);
			scan2(tp, 0);
			expres(ep);
			if ((ep->e_type & LOCAL) != ABSOLUTE)
				error(0, "Expression must be absolute");
			if (listflg) {
		                putc(ep->e_val, dataobj);
		                putc(0, dataobj);
			}
			putob(ep->e_val);
			putob(0);
			scan2(tp, 0);
			expres(ep);
			if ((ep->e_type & LOCAL) != ABSOLUTE)
				error(0, "Expression must be absolute");
			if (listflg) {
		                putc((ep->e_val & 0xff00) >> 8, dataobj);
		                putc(ep->e_val & 0x00ff, dataobj);
			}
			putob((ep->e_val & 0xff00) >> 8);
			putob(ep->e_val & 0x00ff);
			dot += BPD;
			break;
		default:
			dot = align(dot, BPH);
			machine(op);
			n = op->s_type;
			dot += oplen[n];
			break;
		}
	}

/*
 * produce information for given symbol
 * this amounts to adjusting the value if it's global
 */

csym(tp)
register TOKEN *tp;{

	register int val;
	register SYM *s;
	int asmseg, storage, block;

	if (tp->t_state == ID) {
                s = tp->t_sym;
                fputs(s->s_name, symfil);       /* symbol */
                val = s->s_val;
                if ((asmseg = (s->s_type&LOCAL)) > TEXTSEG)
                        val += oseek[asmseg-TEXTSEG]-oseek[0];
                else if (s->s_type == EXTERN | UNDEFINED)
                        val = s->s_len;
		scan2(tp, 0);
		}
	else {
		val = 0;
		asmseg = 0;
		}
	putc('\0', symfil);
	putw(tp->t_val, symfil);        /* symbol number */
	scan2(tp, 0);
	storage = tp->t_val;            /* storage */
	putc((asmseg << 4) | storage, symfil);
	scan2(tp, 0);
	putc(tp->t_val, symfil);        /* class */
	scan2(tp, 0);
	block = tp->t_val;
	puthw(block, symfil);       /* block */
	scan2(tp, 0);
	if (tp->t_state == '-') {
		scan2(tp, 0);
		tp->t_val = -tp->t_val;
		}
	if (block == 1 && val != 0) {
		putw(val, symfil);
		}
	else {
		putw(tp->t_val, symfil);
		}
	scan2(tp, 0);
	puthw(tp->t_val, symfil);       /* type symno */
	scan2(tp, 0);
	puthw(tp->t_val, symfil);       /* chain symno */
	}

/*
 * process a machine op
 */

machine(op)
register SYM *op;{

	register TOKEN *tp;
	register INST *ip;
	int *r1p, *r2p, *d1p, *d2p, *b1p, *b2p;
	int r;
	SYM *symp, *oprd();
	INST inst;

	tp = &curtoke;
	ip = &inst;
	r1p = &(ip->i_reg1);
	r2p = &(ip->i_reg2);
	d1p = &(ip->i_disp1);
	d2p = &(ip->i_disp2);
	b1p = &(ip->i_base1);
	b2p = &(ip->i_base2);
	ip->i_opcode = op->s_val;
	switch(op->s_type) {
		case RR:
			ip->i_reg1 = getabs(0, 15);
			scan2(tp, 1);
			ip->i_reg2 = getabs(0, 15);
			puti(ip, BPH);
			break;
		case RX:
			ip->i_reg1 = getabs(0, 15);
			scan2(tp, 1);
			oprd(r2p, d1p, b1p, 0, 15);
			puti(ip, BPW);
			break;
		case RS1:
			ip->i_reg1 = getabs(0, 15);
			scan2(tp, 1);
			ip->i_reg2 = getabs(0, 15);
			scan2(tp, 1);
			oprd(NULLIP, d1p, b1p, 0, 0);
			puti(ip, BPW);
			break;
		case RS2:
			ip->i_reg1 = getabs(0, 15);
			scan2(tp, 1);
			ip->i_reg2 = 0;
			oprd(NULLIP, d1p, b1p, 0, 0);
			puti(ip, BPW);
			break;
		case SI1:
			oprd(NULLIP, d1p, b1p, 0, 0);
			scan2(tp, 0);
			r = getabs(0, 255);
			ip->i_reg1 = r >> 4;
			ip->i_reg2 = r & 017;
			puti(ip, BPW);
			break;
		case SI2:
			oprd(NULLIP, d1p, b1p, 0, 0);
			ip->i_reg1 = ip->i_reg2 = 0;
			puti(ip, BPW);
			break;
		case S:
			if (tp->t_state == NEWLINE) {
				ip->i_base1 = 0;
				ip->i_disp1 = 0;
				}
			else oprd(NULLIP, d1p, b1p, 0, 0);
			r = op->s_val;
			ip->i_opcode = r >> 8;
			r &= 0377;
			ip->i_reg1 = r >> 4;
			ip->i_reg2 = r & 017;
			puti(ip, BPW);
			break;
		case SS1:
			oprd(r1p, d1p, b1p, 1, 16);
			scan2(tp, 1);
			oprd(r2p, d2p, b2p, 1, 16);
			if (ip->i_reg1) --(ip->i_reg1);
			if (ip->i_reg2) --(ip->i_reg2);
			puti(ip, BPW+BPH);
			break;
		case SS2:
			symp = oprd(r2p, d1p, b1p, 1, 256);
			if (ip->i_reg2) --(ip->i_reg2);
			else if (symp) ip->i_reg2 = symp->s_len;
			else ip->i_reg2 = 0;
			ip->i_reg1 = 0;
			scan2(tp, 1);
			oprd(NULLIP, d2p, b2p, 0, 0);
			puti(ip, BPW+BPH);
			break;
		case SS3:
			symp = oprd(r1p, d1p, b1p, 0, 15);
			if (ip->i_reg1) --(ip->i_reg1);
			else if (symp) ip->i_reg1 = symp->s_len;
			scan2(tp, 1);
			oprd(NULLIP, d2p, b2p, 0, 0);
			scan2(tp, 1);
			ip->i_reg2 = getabs(0, 9);
			puti(ip, BPW+BPH);
			break;
		case BRANCH:
			oprd(r2p, d1p, b1p, 0, 15);
			ip->i_reg1 = op->s_val;
			ip->i_opcode = BC;
			puti(ip, BPW);
			break;
		case BRANCHR:
			ip->i_opcode = BCR;
			ip->i_reg1 = op->s_val;
			ip->i_reg2 = getabs(0, 15);
			puti(ip, BPH);
			break;
		default:
			error(0, "Known symbol botch");
		}
	}

/*
 * read an operand of form  EXPR [ ( ABS [ , ABS ] ) ]
 */

SYM *oprd(xp, dp, bp, lb, ub)
int *xp, *dp, *bp;
int lb, ub;{

	EXPR e;
	register TOKEN *tp;

	tp = &curtoke;
	expres(&e);
	*dp = e.e_val;
	if (xp) *xp = 0;
	if (tp->t_state == '(') {
		scan2(tp, 1);
		if (xp == 0) *bp = getabs(0, 15);
		else {
			if (tp->t_state == ',') {
				scan2(tp, 1);
				*bp = getabs(0, 15);
				}
			else {
				*xp = getabs(lb, ub);
				if (tp->t_state == ',') {
					scan2(tp, 1);
					*bp = getabs(0, 15);
					}
				else if ((e.e_type&LOCAL)!=ABSOLUTE)
					getbase(dp, bp, e.e_type);
				else *bp = 0;
				}
			}
		if (tp->t_state != ')')
			error(0, "Missing right paren");
		scan2(tp, 1);
		}
	else if ((e.e_type&LOCAL) != ABSOLUTE)
		getbase(dp, bp, e.e_type);
	else *bp = 0;

	if (*dp >= MAXDISP || *dp < 0)
		error(0, "Addressibility error");
	return(e.e_symp);
	}

/*
 * allocate a base register from USING list
 */

getbase(d, r, brel)
int *d, *r, brel;{

	register struct using_table *i;
	register int j, k;

	k = MAXDISP;
	*r = 0;
	brel &= LOCAL;
	for (i = &using[0]; i < &using[utop]; i++) {
		if (i->reg == -1) continue;
		j = i->u_rel;
		if (j != brel && (j == DATASEG || j == BSSSEG ||
		    brel == DATASEG || brel == BSSSEG))
			continue;
		j = *d-(i->addr);
		if (j < k && j >= 0){
			k = j;
			*r = i->reg;
			}
		}
	if (k >= MAXDISP || k < 0) {
		if (compiled) {
			/*
			 * blah.s file being assembled was produced
			 * by the compiler from a blah.c file
			 */
		        if (brel == TEXTSEG)
			        quit(2);
		        else
			        quit(3);
		}
		else
		        error(0, "Addressibility error");
	}
	*d = k;
	}

getabs(x, y)
register int x, y;{

	struct exp e;
	register struct exp *ep;

	ep = &e;
	expres(ep);
	if (ep->e_type != ABSOLUTE)
		error(0, "Expression not absolute");
	if (ep->e_val < x || ep->e_val > y)
		error(0, "Value out of range");
	return(ep->e_val);
	}

putob(x)
register int x;{

	register int p, q;

	q = orel;
	if (q != dotrel){
		fflush(outfil);
		orel = q = dotrel;
		p = oseek[q-TEXTSEG]+dot;
		fseek(outfil, p, 0);
		}
	if (q != BSSSEG && size[q-TEXTSEG] != -1)
		putc(x, outfil);
	}

/*
 * put out an instruction
 */

puti(ip, len)
register INST *ip;
register int len;{

	register int p, q, i;
	int n;

	if ((p = orel) != dotrel) {
		fflush(outfil);
		p = orel = dotrel;
		fseek(outfil, oseek[p-TEXTSEG]+dot, 0);
		}
	if (p != BSSSEG && size[p-TEXTSEG] != -1) {
		putc(ip->i_opcode, outfil);
		putc((ip->i_reg1 << 4)+ip->i_reg2, outfil);
		if (listflg) {
		        putc(len, instfil);
		        putw(dot, instfil);
		        putc(ip->i_opcode, instfil);
		        putc((ip->i_reg1 << 4)+ip->i_reg2, instfil);
		}
		if (len == BPH)
			return;
		q = (ip->i_base1 << 12)+ip->i_disp1;
		putc(q >> 8, outfil);
		putc(q & 0377, outfil);
		if (listflg) {
		        putc(q >> 8, instfil);
		        putc(q & 0377, instfil);
			/*
			 * calculate effective address
			 */
			for (n = 0; using[n].reg!=ip->i_base1 && using[n].reg > 0; n++) ;
		        if (using[n].reg != -1)
		                putw(ip->i_disp1 + using[n].addr, instfil);
			else
			        putw(-2, instfil);
		}
		if (len == BPW) return;
		q = (ip->i_base2 << 12)+ip->i_disp2;
		putc(q >> 8, outfil);
		putc(q & 0377, outfil);
		if (listflg) {
		        putc(q >> 8, instfil);
		        putc(q & 0377, instfil);
			/*
			 * calculate effective address
			 */
			for (n = 0; using[n].reg!=ip->i_base2 && using[n].reg > 0; n++) ;
	                if (using[n].reg != -1)
		                putw(ip->i_disp2 + using[n].addr, instfil);
			else
			        putw(-2, instfil);
		        }
		}
	}
